#!/usr/bin/perl -s

$MAX_LIMIT = 5000;

use MBGD::WWW;
use MBGD::SeqRegion;
use MBGD::ProtMotif;

require("MBGD_common.pl");
require("libMBGDaxes.pl");
require "emergency.pl";

##require("libCGI.pl");
##require("libHTML.pl");
##require("libMBGDlogo.pl");

$WWW = MBGD::WWW->new("List of motifs");
%Args = $WWW->cgiGetArgs;

#%Args = &CGI_GetArgs;
$SP       = $Args{'sp'};
$ORF      = $Args{'orf'};
$NAME     = $Args{'name'};
$START    = $Args{'start'};
$LIMIT    = $Args{'limit'};
$TABID    = $Args{'tabid'};

## abnormal values
if ($START < 0) {
    $START = 0;
}
if (! $LIMIT) {
    $LIMIT = 100;
} elsif ($LIMIT < 10) {
    $LIMIT = 10;
} elsif ($MAX_LIMIT < $LIMIT) {
    $LIMIT = $MAX_LIMIT;
}

if (!$NAME){
	$NAME = "$SP:$ORF";
}

$searchRes = MBGD::ProtMotif->findMotifs("$NAME");

$idx     = $START;
$motnum = @{$searchRes};
##$maxrows = $searchRes->{'MAXROWS'};
##$rows    = $searchRes->{'ROWS'};

$fileScript = $ENV{'SCRIPT_NAME'};

$WWW->start_html;

$start = $START + $LIMIT;

if ($motnum == 0) {
    print "<H3>no motif hit</H3>\n";
} else {
    print "<A HREF=RECOG_seqreg_html.pl?name=$NAME&displayMode=Motif&tabid=$TABID>[Graphic Display]</A>";
    print "<b>[TextDisplay]</b>\n";
    if ($start < $motnum) {
   	 $para = $ENV{'QUERY_STRING'};
	    $para =~ s#start=\d+#start=$start#;
    	print "<A HREF=\"$fileScript?$para\">Next Page</A>\n";
    }
    my $g = MBGD::Gene->get("$NAME");
    my $seqlen = $g->length;
    print "<TABLE BORDER>\n";
    print "<TR>";
    foreach $val ("Motif",
                  "From", "To", "MatchReg",
		  "From2", "To2",
                  "Score", "E-value",
                  "Description") {
        print "<TH>$val\n";
    }
    print "</TR>\n";
    if ($START > 0 || $LIMIT < @{$searchRes}) {
	$END = ($START+$LIMIT-1 < $#{$searchRes}) ? $START+$LIMIT-1 : $#{$searchRes};
	@res = @{$searchRes}[$START..$END];
    } else {
	@res = @{$searchRes};
    }
    foreach $refInfo (@res) {
        $motlib   = $refInfo->{'motlib'};
        $motname  = $refInfo->{'motname'};
        $motid    = $refInfo->{'motid'};
        $from     = $refInfo->{'from1'};
        $to       = $refInfo->{'to1'};
        $from2    = $refInfo->{'from2'};
        $to2      = $refInfo->{'to2'};
        $score    = $refInfo->{'score'};
        $eval     = $refInfo->{'eval'};
        $program  = $refInfo->{'program'};
        $descr    = $refInfo->{'descr'};
	$regstr   = MBGD::SeqRegion::getRegionString($from, $to, $seqlen);
	$regstr   = "<PRE>$regstr</PRE>";

        print "<TR><TH>";
        print "<A HREF=\"searchGeneByMotif.pl?";
        print "motlib=$motlib:$program", "&";
        print "motname=$motname", "&";
        print "motid=$motid", "&";
	print "count=1&";
        print "start=0", "&";
        print "limit=$LIMIT", "&";
        print "\" TARGET=\"_top\">";
        print $motlib, ":", $motname;
        print "</A>";
        foreach $val ($from, $to, $regstr, $from2, $to2, $score, $eval, $descr) {
            print "<TD>", $val;
        }
        print "\n";
    }
    print "</TABLE>\n";
}

$WWW->end_html;
exit;

#################################################################################
### searchMotifByGene : ꤷ Gene ˥ޥåդ򸡺
### input : sp, orf
### return: ID
##sub searchMotifByGene {
##    my($sp, $orf, $start, $limit) = @_;
##    my($refRes);
##
##    $refRes = {};
##    $refRes->{'MAXROWS'} = 0;
##    $refRes->{'ROWS'}    = 0;
##    $refRes->{'INFO'}    = [];
##
##    my($db);
##    my($sth);
##    my($tab, $opt);
##    my($rows);
##    my(@dat);
##    my($i);
##
##    $db = MBGD::DB->new($ENV{'MYSQL_DB'});
##
##    $tab        = "protmotif";
####    my $MOTLIBOPT = "motlib != 'COG'";
##
##    $opt->{'columns'}.= "motlib, motname, motid, from1, to1, ";
##    $opt->{'columns'}.= "score, eval, program, descr";
##    $opt->{'where'}   = "sp='$sp' and name='$orf'";
##    $opt->{'where'}  .= " and $MOTLIBOPT" if ($MOTLIBOPT);
##    $opt->{'order'}   = "eval";
##    $opt->{'limit'}   = "$start,$limit";
##
##    $refRes = $db->select_fetch($tab, $opt);
##
##    return $refRes;
##}
##
