#!/usr/bin/perl -s
use MBGD::DB;
require 'MBGD_Conf.pl';
$main::DEBUG = 1;
$dbname = $main::DBNAME_MBGD;
$db = new MBGD::DB($dbname);
$opt->{'columns'} = '*';
$opt->{'order'} = 'sp';
$res = $db->select_fetch('genome', $opt);

$selOpt = '';
#$selOpt .= "<option value=\"zzz1\">[zzz1] Test</option>\n";
#$selOpt .= "<option value=\"zzz2\">[zzz2] Test</option>\n";
foreach my$ref (@{$res->{'INFO'}}) {
    my($sp) = $ref->{'sp'};
    my($name) = $ref->{'orgname'};
    my($str) = $ref->{'strain'};
    if ($str !~ /^\s*$/) {
        $str = "($str)";
    }
    $selOpt .= "<option value=\"$sp\">[$sp] $name$str</option>\n";
}

print <<EOF;
Content-type: text/html

<html>
<head>
<title> DomClust Test Page </title>
<script>
function setDisabled(obj, name) {
    var elm;
    var i;
    for(i = 0; i < this.document.form_domclust.elements.length; i++) {
        var elm = this.document.form_domclust.elements[i];
        if (elm.name == name) {
            elm.disabled = ! obj.checked;
            break;
        }
    }

//    eval('this.document.form_domclust.' + name + '.disabled=' + ! obj.checked);
}
</script>
</head>
<body bgcolor="white">
<!---
<h2>Download Homology Data for <A HREF=http://mbgd.genome.ad.jp/domclust/>DomClust</A> from <A HREF=http://mbgd.genome.ad.jp/>MBGD</A></h2><h3>Select organisms</h3>(Currently maximum 50 species. Note that the output may be HUGE!)<br />
--->
<h2>DomClust Test</h2>
<form name="form_domclust" method="post" action="/htbin/RECOG/domclust.cgi" enctype="application/x-www-form-urlencoded" target="_blank">
<table border="1">
<tr><th> In Group </th> <th> Out Group </th> </tr>
<tr>
<td>
<select name="ingroup" size="15" multiple="multiple">
$selOpt
</select>
</td>
<td>
<select name="outgroup" size="15" multiple="multiple">
$selOpt
</select>
</td>
</tr>
</table>
<!-- <br /> -->
<!---
<A HREF=/htbin/create_tax?mode=mbgd&action=gethom&species=>organisms selection on the taxonomy browser</A>
<h3>Set options</h3>
<table border="1" align="left">
--->
<table border="1">
  <tr><th colspan="3"> Set Options</th></tr>
  <tr><td> No-execute domclust </td>
      <td><label><input type="checkbox" name="NO_EXEC" value="yes" />No-exec</label>
          </td>
      <td>Check species name.</td></tr>
  <tr><td> clusterID </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'clusterID');" />
          <input type="text" name="clusterID" value="" disabled /></td>
      <td></td></tr>
  <tr><td> GET STATUS ONLY </td>
      <td><label><input type="checkbox" name="GET_STATUS_ONLY" value="yes" />get status only</label>
          </td>
      <td>Check species name.</td></tr>
  <tr><td> Use domclust dump    </td>
      <td><label><input type="radio" name="USE_DOMCLUST_DUMP" value="1" checked="checked" />Use</label>
          <label><input type="radio" name="USE_DOMCLUST_DUMP" value="0" />NOT Use </label>
          </td>
      <td> </td></tr>
  <tr><td> eval    </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'eval');" />
          <input type="text" name="eval" value="0.001" disabled /></td>
      <td> Cutoff BLAST E-value </td></tr>
  <tr><td> score    </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'score');" />
          <input type="text" name="score" value="60" disabled /></td>
      <td> Cutoff DP score </td></tr>
  <tr><td> ident    </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'ident');" />
          <input type="text" name="ident" value="" disabled /></td>
      <td> Cutoff percent identity </td></tr>
  <tr><td> pam    </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'pam');" />
          <input type="text" name="pam" value="" disabled /></td>
      <td> Cutoff PAM distance </td></tr>
  <tr><td> besthit    </td>
      <td><label><input TYPE="radio" NAME="besthit" VALUE="none" CHECKED>none</label>
          <label><input TYPE="radio" NAME="besthit" VALUE="bidirec" >bidirec</label>
          <label><input TYPE="radio" NAME="besthit" VALUE="unidirec" >unidirec</label>
      </td>
      <td> Best hit criterion </td></tr>
  <tr><td> ratiocut    </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'ratiocut');" />
          <input type="text" name="ratiocut" value="" disabled /></td>
      <td> Cutoff ratio of the score against the best </td></tr>
  <tr><td> sim_measure (-S / -d)    </td>
      <td><label><input type="radio" name="sim_measure" value="score" checked="checked">score</label>
          <label><input type="radio" name="sim_measure" value="pam">pam</label>
          <label><input type="radio" name="sim_measure" value="identity">identity</label>
      </td>
      <td> use similarity or distance as a measure of relatedness </td></tr>
  <tr><td> -c#   </td>
      <td></td>
      <td> Cutoff DP score / Cutoff PAM distance </td></tr>
  <tr><td> -ci#   </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'cutoff_ingroup');" />
          <input type="text" size="20" name="cutoff_ingroup" disabled /></td>
      <td> Cutoff DP score / Cutoff PAM distance / Cutoff IDENTITY for in-group</td></tr>
  <tr><td> missdist(-m#)   </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'missdist');" />
          <input type="text" size="20" name="missdist" disabled /></td>
      <td> score/distance for missing relationships (m &lt; c) </td></tr>
  <tr><td> missdist_ratio(-mr#)  </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'missdist_ratio');" />
          <input type="text" size="20" name="missdist_ratio" disabled /></td>
      <td> specify a missing score as a ratio to c (0 &lt; mr &lt; 1) [0.95] </td></tr>
  <tr><td> cutoff2(-C#)   </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'cutoff2');" />
          <input type="text" size="20" name="cutoff2" disabled /></td>
      <td> cutoff score for domain split (c &le; C) </td></tr>
  <tr><td> coverage2(-V#)   </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'coverage2');" />
          <input type="text" size="20" name="coverage2" disabled /></td>
      <td> alignment coverage for domain split (0 &le; V &le; 1) </td></tr>
  <tr><td> (-n#)   </td>
      <td>1</td>
      <td> minimum # of organisms in clusters to be output </td></tr>
  <tr><td> (-ne#)  </td>
      <td>1</td>
      <td> minimum # of entries in clusters to be output </td></tr>
  <tr><td> phylocut(-p#)   </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'phylocut');" />
          <input type="text" size="20" name="phylocut" disabled /></td>
      <td> ratio of phylogenetic pattern overlap for tree cutting [0.5] </td></tr>
  <tr><td> clustmode(-H)    </td>
      <td><label><input type="radio" name="clustmode" value="combined" checked="checked">combined</label>
          <label><input type="radio" name="clustmode" value="homology">homology</label>
          <label><input type="radio" name="clustmode" value="orthology">orthology</lavel>
      </td>
      <td> homology clustering (i.e. skip the tree cutting) </td></tr>
  <tr><td> taxonlevel(-t)    </td>
      <td><select name="taxonlevel">
          <option VALUE="none" SELECTED>none
          <option VALUE="species" >species
          <option VALUE="genus" >genus
          <option VALUE="family" >family
          <option VALUE="order" >order
          </select>
      <td> Phylogenetically related organisms </td></tr>
  <tr><td> adjincl(-ai#)  </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'adjincl');" />
          <input type="text" size="20" name="adjincl" disabled /></td>
      <td> member overlap for absorbing adjacent small clusters (0 &le; ai &le; 1) </td></tr>
  <tr><td> adjovlp(-ao#)  </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'adjovlp');" />
          <input type="text" size="20" name="adjovlp" disabled /></td>
      <td> member overlap for merging adjacent clusters (0 &le; ao &le; ai) </td></tr>
  <tr><td> Ohorizweight  </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'horizweight');" />
          <input type="text" size="20" name="horizweight" disabled /></td>
      <td> relative weight for horiz. transfer (0 &le; x &le; 1) [0] </td></tr>
  <tr><td> OtaxMapSpec  </td>
      <td><input type="checkbox" name="" value="" onclick="setDisabled(this, 'taxMapSpec');" />
          <input type="text" size="20" name="taxMapSpec" disabled /></td>
      <td> target species for taxonomy mapping [=meta] </td></tr>
  <tr><td>out_format</td>
      <td colspan="2">
          <label><input type="radio" name="output_format" value="list" checked > list </label>&nbsp;
          <label><input type="radio" name="output_format" value="text"         > text </label>&nbsp;
          <label><input type="radio" name="output_format" value="html"         > html </label>&nbsp;
          <label><input type="radio" name="output_format" value="o11"          > o11  </label>&nbsp;
      </td>
  </tr>
  <tr><td>output_type</td>
      <td colspan="2">
          <label><input type="radio" name="output_type" value="complete" checked > complete </label>&nbsp;
          <label><input type="radio" name="output_type" value="phylopat"         > phylopat </label>&nbsp;
          <label><input type="radio" name="output_type" value="count"            > count    </label>&nbsp;
      </td>
  </tr>
</table>
<input type="submit" name="submit" value="submit"/>
</form>
</body>
</html>

EOF
