#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RECOG;

###############################################################################
sub get_sth_taxmap {
    my($tabid) = shift;
    my($mapspecid) = shift;
    my($clustid) = shift;
    my($mapspec) = shift;

    #
    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);

    my($tabname) = $main::TBL_DOMTAXMAPIDX;
    my($sta) = $db->exist_table($tabname);
    if (!$sta) {
        return;
    }

    #
    if (!$mapspecid) {
        my($sql) = "select * from $tabname where (dumpid in ('$tabid', '$clustid') or clustid in ('$tabid', '$clustid'))";
        my($sth) = $db->execute($sql);
        if ($sth->rows() == 0) {
            return;
        }

        while(my$ref=$sth->fetchrow_hashref()) {
            my(@mapspec_list) = split(/,/, $ref->{'mapspec'});
            foreach my$sp (@mapspec_list) {
                if ($sp eq $mapspec) {
                    $mapspecid = $ref->{'mapspecid'};
                    last;
                }
            }
        }

        if (!$mapspecid) {
            return;
        }
    }

    #
    my($tabname) = $main::TBL_DOMTAXMAP . '_' . $mapspecid;
    my($sql) = "select * from $tabname";
    $sql .= " where clustid='$clustid'" if ($clustid);
    $sql .= " order by clustid, seqname, lower, upper";
    my($sth) = $db->execute($sql);

    return $sth;
}

###############################################################################
sub download_taxmap {
    my($tabid) = shift;
    my($mapspecid) = shift;
    my($clustid) = shift;
    my($mapspec) = shift;

    #
    print "Content-type: text/plain\n";
    print "\n";
    print '#', join("\t", 'Cluster', 'Name', 'lower(score,pam)', 'upper(score,pam)'), "\n";

    my(@spec_list) = split(/,/, $mapspec);
    foreach my$spec (@spec_list) {
        my($sth) = get_sth_taxmap($tabid, $mapspecid, $clustid, $spec);
        if (!$sth) {
            next;
        }

        #
        while (my$ref=$sth->fetchrow_hashref()) {
            my($sp) = split(/\:/, $ref->{'seqname'});
            if ($sp ne $spec) {
                next;
            }
            print join("\t", $ref->{'clustid'},
                             $ref->{'seqname'},
                             $ref->{'lower'},
                             $ref->{'upper'}), "\n";
        }
    }

    return;
}

###############################################################################
sub view_taxmap {
    my($tabid) = shift;
    my($mapspecid) = shift;
    my($clustid) = shift;
    my($mapspec) = shift;

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/mbgd_button.css" />
</head>
<body>
MAPSPECID : $mapspecid<br>
EOB

    print <<EOB;
[ <a href="/htbin/RECOG/view_taxmap.cgi?mapspecid=$mapspecid&clustid=$clustid&mode=text">Download text</a> ]
EOB

    if ($clustid) {
        print <<EOB;
[ <a href="/htbin/RECOG/view_taxmap.cgi?mapspecid=$mapspecid">View ALL</a> ]
EOB
    }

    print <<EOB;
<table border>
<tr><th>Cluster</th><th>Name</th><th>lower(score,pam)</th><th>upper(score,pam)</th>
</tr>
EOB

    my(@spec_list) = split(/,/, $mapspec);
    foreach my$spec (@spec_list) {
        my($sth) = get_sth_taxmap($tabid, $mapspecid, $clustid, $spec);
        if (!$sth) {
#            print "<h1>Sorry, no data [$mapspecid]</h1>\n";
            next;
        }

        while (my$ref=$sth->fetchrow_hashref()) {
            my($sp) = split(/\:/, $ref->{'seqname'});
            if ($sp ne $spec) {
                next;
            }
            print <<EOB;
<tr><td>$ref->{'clustid'}</td>
    <td>$ref->{'seqname'}</td>
    <td>$ref->{'lower'}<br></td>
    <td>$ref->{'upper'}<br></td>
</tr>
EOB
        }
    }

    print <<EOB;
</table>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();
    my($tabid) = $cgi->param('tabid');
    my($mapspecid) = $cgi->param('mapspecid');
    my($clustid) = $cgi->param('clustid');
    my($mapspec) = $cgi->param('mapspec');
    my($mode) = $cgi->param('mode');
    if ($mode =~ /^text/i) {
        download_taxmap($tabid, $mapspecid, $clustid, $mapspec);
    }
    else {
        view_taxmap($tabid, $mapspecid, $clustid, $mapspec);
    }
}

###############################################################################
1;
###############################################################################
