#!/usr/bin/perl -s
use strict;
use CGI;
use FileHandle;
use MBGD::DB;
use MbgdUserGenomeCommon;
use RecogBuild;
use RecogProjectCommon;
use RECOG::RecogProject;
require "InfoSpec.pl";

###############################################################################
#
sub del_user_genome {
    my($formOpt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($auth) = RECOG::RecogProject->new();
    my($sta) = $auth->permit_project_user($user,
                                          $RECOG::RecogProject::ID_PRJ_system,
                                          $RECOG::RecogProject::ACT_ADD_PRJ);
    if (!$sta) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($spid) = $formOpt->{'spid'};

    #
    my($file_spid_tab) = "$ENV{'RECOG_HOME'}/etc/spid.tab";
    my($spid_tab_ref) = getInfoSpecTab($file_spid_tab);
    my($sp) = $spid_tab_ref->{'SPID2NAME'}->{"$spid"};
    delInfoSpecTabEntry($spid_tab_ref, $spid);
    setInfoSpecTab($file_spid_tab, $spid_tab_ref);

    #
    RecogBuild::remove_user_genome($spid, $sp);

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
<script>
this.top.opener.location.reload();
</script>
</head>

<body>

<div id="id_msg">
<h1>Delete user genome</h1>
</div>

Done.
<form>
<input type="button" name="btn_close" value="Close" onclick="self.close();">
</form>
</body>
</html>

EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    foreach my$key ('spid') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    del_user_genome($formOpt);
}

###############################################################################
1;#
###############################################################################
