#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use File::Path;
use GenBank;
use MBGD::WWW;
use MbgdUserGenomeCommon;

###############################################################################
#
sub saveUploadFileGbk {
    my($uid) = shift;
    my($idUserGenome) = shift;
    my($idUserChromosome) = shift;
    my($fhGbk) = shift;
    my($fileError) = shift;

    my($dirUc) = MbgdUserGenomeCommon::getDirUserChromosome($uid, $idUserGenome, $idUserChromosome);

    my($mode) = MbgdUserGenomeCommon::load_mode_chromosome($uid, $idUserGenome, $idUserChromosome);

    # ¾ΥǡΥե
    my($fileGeneTab) = "$dirUc/origGeneTab";
    my($fileProtein) = "$dirUc/origProtein";
    my($fileDna)     = "$dirUc/origDna";
    unlink($fileGeneTab) if (-e $fileGeneTab);
    unlink($fileProtein) if (-e $fileProtein);
    unlink($fileDna)     if (-e $fileDna);

    #
    my($fileGbk) = "$dirUc/ncbiGbk";
    my($refGeneTab);
    if ($fhGbk) {
        # upload ե¸
        MbgdUserGenomeCommon::saveFh2Local($fhGbk, $fileGbk);
    }

    if (-e $fileGbk) {
        my($spUg) = MbgdUserGenomeCommon::getUserGenomeSpec($idUserGenome);
        MbgdUserGenomeCommon::clearBlastFinishedSpec($uid, $spUg);

        #
        my($genbank_ref) = GenBank->new($fileGbk);

	my(@err_msg_all);
        while (my $data = $genbank_ref->read_entry()) {
        	my(@err_msg) = $genbank_ref->get_status_read_entry();
		if (scalar(@err_msg) != 0) {
##        		MbgdUserGenomeCommon::saveErrorMessage($fileError, @err_msg);
	        } else {
       	    		# եå
#	        	$refGeneTab = MbgdUserGenomeCommon::readGeneTab($uid,
	        	$refGeneTab = MbgdUserGenomeCommon::readGbkFile($data,
                                                            $idUserGenome,
                                                            $idUserChromosome, '', '', $genbank_ref);
		        checkUploadDataFile($uid,
                                $idUserGenome,
                                $idUserChromosome,
                                $refGeneTab,
                                $refGeneTab,
                                $fileError,
                                @{$refGeneTab->{'MSG_ERR'}});
		}
		push(@err_msg_all, @err_msg);
        }
	if (scalar(@err_msg_all) != 0) {
        	MbgdUserGenomeCommon::saveErrorMessage($fileError, @err_msg_all);
	}
    }

    return $refGeneTab;
}

###############################################################################
#
sub saveUploadFileOrig {
    my($uid) = shift;
    my($idUserGenome) = shift;
    my($idUserChromosome) = shift;
    my($fhGeneTab) = shift;
    my($fhProtein) = shift;
    my($fhDna) = shift;
    my($fileError) = shift;
    my($length_chromosome) = shift;
    my($seqtype) = shift;
    my($refOrig) = {};
    my($msg);

    #
    my($dirUc) = MbgdUserGenomeCommon::getDirUserChromosome($uid, $idUserGenome, $idUserChromosome);
    unlink($fileError) if (-e $fileError);

    # ¾ΥǡΥե
    my($fileGbk) = "$dirUc/ncbiGbk";
    unlink($fileGbk) if (-e $fileGbk);

    #
    my($spUg) = MbgdUserGenomeCommon::getUserGenomeSpec($idUserGenome);

    #
    my($fileGeneTab) = "$dirUc/origGeneTab";
    if ($fhGeneTab) {
        MbgdUserGenomeCommon::saveFh2Local($fhGeneTab, $fileGeneTab);
        MbgdUserGenomeCommon::clearBlastFinishedSpec($uid, $spUg);
    }

    my($fileProtein) = "$dirUc/origProtein";
    if ($fhProtein) {
        MbgdUserGenomeCommon::saveFh2LocalFasta($fhProtein, $fileProtein);
        MbgdUserGenomeCommon::clearBlastFinishedSpec($uid, $spUg);

    }
    if (! -e $fileGeneTab || -z $fileGeneTab) {
            MbgdUserGenomeCommon::createGeneTabForProtein($fileProtein, $fileGeneTab);
    }

    my($fileDna) = "$dirUc/origDna";
    if ($fhDna) {
        # upload 줿ե¸
        MbgdUserGenomeCommon::saveFh2Local($fhDna, $fileDna);

        # upload 줿Ĺ򥫥
        $refOrig->{'length'} = 0;
        my($fh) = new FileHandle("$fileDna");
        while (my$line = $fh->getline()) {
            next if ($line =~ /^\s*>/);

            $line =~ s#[\r\n]*$##;
            $refOrig->{'length'} += length($line);
        }
        $fh->close();

        $length_chromosome = $refOrig->{'length'};
    }

    #
    $refOrig->{'N_CDS'} = 0;
    $refOrig->{'N_CDS_PROTSEQ'} = 0;
    $refOrig->{'N_PROTSEQ'} = 0;

    # եå
    my($refFasta);
    if (-e $fileProtein) {
        $refFasta   = MbgdUserGenomeCommon::readOrigFasta($fileProtein);
        $refOrig->{'N_PROTSEQ'} = scalar(@{$refFasta->{'LIST'}});
        if (!-e $fileGeneTab) {
            # build dummy gene data for protseq
            my($refGeneTab) = {};
            $refGeneTab->{'HASH'} = {};
            $refGeneTab->{'LIST'} = [];
            $refGeneTab->{'MSG_ERR'} = [];

            if ($length_chromosome <= 0) {
#                push(@{$refGeneTab->{'MSG_ERR'}}, "Illegal chromosome length.");
            }

            foreach my$ref (@{$refFasta->{'LIST'}}) {
                my($id) = $ref->{'ID'};
                my($descr) = $ref->{'TITLE'};
                my($ent) = {};
		my($seqlen) = length( $ref->{'SEQ'} ) * 3;	## length of nucleotide sequence

                $ent->{'ID'}        = $id;
                $ent->{'GENE_NAME'} = '';
                $ent->{'FROM'}      = 1;
                $ent->{'TO'}        = $seqlen;
                $ent->{'DIR'}       = 0;
                $ent->{'TYPE'}      = 'CDS';
                $ent->{'DESC'}      = $descr;

                $refGeneTab->{'HASH'}->{"$id"} = $ent;
                push(@{$refGeneTab->{'LIST'}}, $ent);
            }

            checkUploadDataFile($uid,
                                $idUserGenome,
                                $idUserChromosome,
                                $refGeneTab,
                                $refFasta,
                                $fileError,
                                @{$refGeneTab->{'MSG_ERR'}},
                                @{$refFasta->{'MSG_ERR'}});
        }
    }
    if (-e $fileGeneTab) {
        my($refGeneTab) = MbgdUserGenomeCommon::readGeneTab($uid,
                                                            $idUserGenome,
                                                            $idUserChromosome);
        foreach my$ref (@{$refGeneTab->{'LIST'}}) {
            if ($ref->{'TYPE'} && $ref->{'TYPE'} !~ /^cds$/i) {
                next;
            }
            $refOrig->{'N_CDS'}++;
        }

        if (-e $fileProtein) {
#print STDERR "REF:$refFasta;$refFasta->{HASH}\n";
            foreach my$ref (@{$refGeneTab->{'LIST'}}) {
                if ($ref->{'TYPE'} && $ref->{'TYPE'} !~ /^cds$/i) {
                    next;
                }
                my($id) = $ref->{'ID'};
                my($seq) = $refFasta->{'HASH'}->{"$id"};
#print STDERR "III>>>>>$id, $seq\n";
                if ($seq !~ /^\s*$/) {
                    $refOrig->{'N_CDS_PROTSEQ'}++;
                }
            }

            checkUploadDataFile($uid,
                                $idUserGenome,
                                $idUserChromosome,
                                $refGeneTab,
                                $refFasta,
                                $fileError,
                                @{$refGeneTab->{'MSG_ERR'}},
                                @{$refFasta->{'MSG_ERR'}});

#print STDERR "#>>$refOrig->{N_CDS_PROTSEQ},$refOrig->{N_CDS}\n";
            if ($refOrig->{'N_CDS_PROTSEQ'} < $refOrig->{'N_CDS'}) {
	        print STDERR "modUserChromosome: Status ERROR: Num CDS in protseq ($refOrig->{N_CDS_PROTSEQ}) is smaller than in genetab ($refOrig->{N_CDS})\n";
                MbgdUserGenomeCommon::setUserChromosomeStatus($uid,
                                                              $idUserGenome,
                                                              $idUserChromosome,
                                                              $main::FALSE);
            }
        }
        else {
            # no protein sequence
	    print STDERR "modUserChromosome: Status ERROR: No protein sequence\n";
            MbgdUserGenomeCommon::setUserChromosomeStatus($uid,
                                                          $idUserGenome,
                                                          $idUserChromosome,
                                                          $main::FALSE);
        }
    }

    return $refOrig;
}

###############################################################################
#
sub checkUploadDataFile {
    my($uid) = shift;
    my($idUserGenome) = shift;
    my($idUserChromosome) = shift;
    my($refGeneTab) = shift;
    my($refFasta) = shift;
    my($fileError) = shift;
    my(@listReadErrMsg) = @_;
    my($msg);
#    my($MAX_LEN_LOCUSTAG) = 24;
    my($MAX_LEN_LOCUSTAG) = 32;

    #
    my($errCount) = scalar(@listReadErrMsg);

    #
    my(@listErrMsg);
    my($refGene);
print STDERR "####CCC$uid,$idUserGenome,$idUserChromosome\n";
    foreach $refGene (@{$refGeneTab->{'LIST'}}) {
        my($id) = $refGene->{'ID'};
        if ($MAX_LEN_LOCUSTAG < length($id)) {
            $msg = sprintf("Gene ID is too long (ID='%s' > $MAX_LEN_LOCUSTAG characters).", $id);
            push(@listErrMsg, $msg);
        }
        if ($refGene->{'type'} eq 'CDS' && ! exists($refFasta->{'HASH'}->{"$id"})) {
            $msg = sprintf("Not found sequence (ID=%s).", $id);
            push(@listErrMsg, $msg);
        }
    }
    foreach my$seqid (sort(keys(%{$refFasta->{'HASH'}}))) {
        if ($MAX_LEN_LOCUSTAG < length($seqid)) {
            $msg = sprintf("Proteinseq ID is too long (ID='%s' >  $MAX_LEN_LOCUSTAG characters).", $seqid);
            push(@listErrMsg, $msg);
        }
    }
    $errCount += scalar(@listErrMsg);

    if ($errCount == 0) { # 顼̵
        # Ʊ UserGenome ¾ UserChromosome Ʊ ID ¸ߤʤ
        my($cid);
        for($cid = 1; $cid <= $MbgdUserGenomeCommon::MAX_USER_CHROMOSOME; $cid++) {
            if ($idUserChromosome == $cid) {
                # ʬ(UserChromosome) SKIP
                next;
            }

            my($dirUc) = MbgdUserGenomeCommon::getDirUserChromosome($uid,
                                                                    $idUserGenome,
                                                                    $cid);
            if (! -e $dirUc) {
                next;
            }

            if (! MbgdUserGenomeCommon::getUserChromosomeStatus($uid, $idUserGenome, $cid)) {
                next;
            }

            #
            my($refGeneTab2) = MbgdUserGenomeCommon::readGeneTab($uid, $idUserGenome, $cid);
            foreach $refGene (@{$refGeneTab->{'LIST'}}) {
                my($id) = $refGene->{'ID'};
                if (exists($refGeneTab2->{'HASH'}->{"$id"})) {
                    $msg = sprintf("ID '%s' Exists at Chr#%d.", $id, $cid);
                    push(@listErrMsg, $msg);
                }
            }
        }

        $errCount = scalar(@listErrMsg);
        if ($errCount == 0) {
            # Upload 줿ǡ OK
            MbgdUserGenomeCommon::setUserChromosomeStatus($uid,
                                                          $idUserGenome,
                                                          $idUserChromosome,
                                                          $main::TRUE);
        }
        else {
            MbgdUserGenomeCommon::saveErrorMessage($fileError, @listErrMsg);
        }
    }
    else {
        MbgdUserGenomeCommon::saveErrorMessage($fileError,
                                               @listReadErrMsg,
                                               @listErrMsg);
    }

    return;
}

###############################################################################
#
sub modUserChromosome {
    my($uid) = shift;
    my($formOpt) = shift;
    my($existsSomeErrors) = '';

    if ($formOpt->{'id_user_chromosome'} <= 0) {
        #  UserChromosome ---> ID ȯ
        $formOpt->{'id_user_chromosome'} = MbgdUserGenomeCommon::getNewUserChromosomeId($uid, $formOpt->{'id_user_genome'});
        if (! $formOpt->{'id_user_chromosome'}) {
            # ȯֽʤ ---> ¸ UserChromosome Ƥ餦ɬפ
            return;
        }

        #
        MbgdUserGenomeCommon::setUserGenomeDbStatus($uid, $main::FALSE);
    }

    #
    my($idUserGenome)     = $formOpt->{'id_user_genome'};
    my($idUserChromosome) = $formOpt->{'id_user_chromosome'};
    if ($formOpt->{'chromosome_name'} =~ /^\s*$/) {
        $formOpt->{'chromosome_name'} = 'chromosome' . $idUserChromosome;
    }
    my($dirUc) = MbgdUserGenomeCommon::getDirUserChromosome($uid, $idUserGenome, $idUserChromosome);
    mkpath($dirUc, 0, 0750) if (! -e "$dirUc");

    #
    my($fileGbk)     = "$dirUc/ncbiGbk";
    my($fileGeneTab) = "$dirUc/origGeneTab";
    my($fileProtein) = "$dirUc/origProtein";
    my($fileDna)     = "$dirUc/origDna";
    my($fileError)   = "$dirUc/error.txt";

    #
    my($fileStatus) = "$dirUc/statusOk";
    if ($formOpt->{'file_gbk'} || -e $fileGbk) {
        # ǡե뤬 upload 줿
        MbgdUserGenomeCommon::setUserGenomeDbStatus($uid, $main::FALSE);
        unlink($fileError) if (-e $fileError); # clear error log

        MbgdUserGenomeCommon::setUserChromosomeStatus($uid,
                                                      $idUserGenome,
                                                      $idUserChromosome,
                                                      $main::FALSE);

        my($refGbk) = saveUploadFileGbk($uid,
                                        $idUserGenome,
                                        $idUserChromosome,
                                        $formOpt->{'file_gbk'},
                                        $fileError);

        #
        MbgdUserGenomeCommon::delUserChromosomeTables($uid,
                                                      $idUserGenome,
                                                      $idUserChromosome);

        if ($refGbk) {
            $formOpt->{'chromosome_length'} = $refGbk->{'length'};
            $formOpt->{'chromosome_shape'}  = $refGbk->{'shape'};
            $formOpt->{'N_CDS'}         = $refGbk->{'N_CDS'};
            $formOpt->{'N_CDS_PROTSEQ'} = $refGbk->{'N_CDS_PROTSEQ'};
        }
    }
    elsif ($formOpt->{'file_gene_table'} || -e $fileGeneTab ||
           $formOpt->{'file_protein'}    || -e $fileProtein ||  
           $formOpt->{'file_dna'}        || -e $fileDna) {
        # ǡե뤬 upload 줿
        MbgdUserGenomeCommon::setUserGenomeDbStatus($uid, $main::FALSE);
        unlink($fileError) if (-e $fileError); # clear error log

        MbgdUserGenomeCommon::setUserChromosomeStatus($uid,
                                                      $idUserGenome,
                                                      $idUserChromosome,
                                                      $main::FALSE);

        my($refOrig) = saveUploadFileOrig($uid,
                                          $idUserGenome,
                                          $idUserChromosome,
                                          $formOpt->{'file_gene_table'},
                                          $formOpt->{'file_protein'},
                                          $formOpt->{'file_dna'},
                                          $fileError,
                                          $formOpt->{'chromosome_length'},
					  $formOpt->{'seqtype'});
        if (exists($refOrig->{'length'})) {
            $formOpt->{'chromosome_length'} = $refOrig->{'length'};
        }
        $formOpt->{'N_CDS'}         = $refOrig->{'N_CDS'};
        $formOpt->{'N_CDS_PROTSEQ'} = $refOrig->{'N_CDS_PROTSEQ'};
        $formOpt->{'N_PROTSEQ'}     = $refOrig->{'N_PROTSEQ'};
    }
    elsif (-e $fileGbk) {
        # GBK Υե뤬 upload Ѥߤξ硢length/shape ιԲ
        my($refUc) = MbgdUserGenomeCommon::loadUserChromosomeInfo($uid, $idUserGenome, $idUserChromosome);
        $formOpt->{'chromosome_shape'}  = $refUc->{'chromosome_shape'};
        $formOpt->{'chromosome_length'} = $refUc->{'chromosome_length'};
        $formOpt->{'seqtype'} = $refUc->{'seqtype'};
    }

    #
    my($count_upload_data) = '';
    if (defined($formOpt->{'N_CDS'})) {
        $count_upload_data = "<table border>\n"
                           . "<tr><th>CDS</th>\n"
                           . "    <td>$formOpt->{'N_CDS'}</td>\n"
                           . "</tr>\n"
                           . "<tr><th>Protein Sequence(Linked CDS)</th>\n"
                           . "    <td>$formOpt->{'N_CDS_PROTSEQ'}</td>\n"
                           . "</tr>\n"
                           . "<tr><th>Protein Sequence(Upload)</th>\n"
                           . "    <td>$formOpt->{'N_PROTSEQ'}</td>\n"
                           . "</tr>\n"
                           . "</table>\n";
    }
    if (-e $fileError) {
        $existsSomeErrors = <<EOB;
[<a href="/htbin/recog_build/viewErrorMessage.cgi?id_user_genome=$idUserGenome&id_user_chromosome=$idUserChromosome" target="win_errors">View Error Message(s)</a>]
EOB

    }

    # UserChromosome ¸
    MbgdUserGenomeCommon::saveUserChromosomeInfo($uid, $formOpt);

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title></title>
<link rel="stylesheet" href="/css/mymbgd.css" type="text/css" />
<script language="JavaScript" src="/js/mymbgd.js"></script>
<script>
function isChanged() {
    return isChangedFormData(this.document);
}

</script>
</head>

<body onload="updateUserGenomeList(); updateUserChromosomeList($idUserGenome);">

<form>
Saved.
$count_upload_data
<!--
$existsSomeErrors
-->
<br>
<input type="button" value="Ok" onclick="updateUserChromosome('$idUserGenome', '$idUserChromosome');">
</form>

</body>
</html>
EOB

}

###############################################################################
if ($0 eq __FILE__) {
    my($WWW) = MBGD::WWW->new;
    my($uid) = $WWW->uid();

    my($key);

    #
    my($cgi) = new CGI();

    my($formOpt) = {};

    foreach $key ('id_user_genome',
                  @MbgdUserGenomeCommon::LST_KEY_CHROMOSOME,
                  @MbgdUserGenomeCommon::LST_FIL_CHROMOSOME) {
        $formOpt->{"$key"} = $cgi->param($key);
    }
    ## handling compressed gbk file
    if ($formOpt->{'file_gbk'} =~ /\.gz/) {
	my($tmpfile) = $cgi->tmpFileName($formOpt->{'file_gbk'});
	$formOpt->{'file_gbk'} = FileHandle->new("$::CMD_gzip -dc $tmpfile |");
    }

    modUserChromosome($uid, $formOpt);
}
###############################################################################
1;#
###############################################################################
