#!/usr/bin/perl -s
use strict;
use CGI;
use File::Path;
use MBGD::WWW;
use MbgdUserGenomeCommon;

###############################################################################
#
sub modUserChromosomeWin {
    my($uid) = shift;
    my($formOpt) = shift;

    #
    my($idUserGenome)     = $formOpt->{'id_user_genome'};
    my($idUserChromosome) = $formOpt->{'id_user_chromosome'};
    my($modNewUserChr)    = $formOpt->{'chromosome_data_type'};
    my($refUserChromosome) = {};
    my($userChromosomeNo) = '[NEW]';
    my($spidUserGenome) = sprintf("gu%05d", $idUserGenome);
    if ($idUserGenome != 0) {
        if ($idUserChromosome < 0) {
            $idUserChromosome = MbgdUserGenomeCommon::getNewUserChromosomeId($uid, $idUserGenome);
        }
        if ($idUserChromosome == 0) {
            $idUserChromosome = MbgdUserGenomeCommon::getFirstUserChromosomeId($uid, $idUserGenome);
            if ($idUserChromosome == 0) {
                print "Location: /recog_build/blank.html\n";
                print "\n";
                return;
            }
        }

        if ($idUserChromosome > 0) {
            # ϿѤߤ UserChromosome μ
            $refUserChromosome = MbgdUserGenomeCommon::loadUserChromosomeInfo($uid, $idUserGenome, $idUserChromosome);

            $userChromosomeNo = "#$idUserChromosome";
        }
        else {
            $idUserChromosome = 1;
        }
    }

    my($staCircular) = 'checked';
    my($staLinear)   = '';
    if ($refUserChromosome->{'chromosome_shape'} =~ /^linear$/i) {
        $staCircular = '';
        $staLinear   = 'checked';
    }
    my($staChromosome) = 'checked';
    my($staPlasmid)   = '';
    if ($refUserChromosome->{'seqtype'} =~ /^plasmid$/i) {
        $staChromosome = '';
        $staPlasmid   = 'checked';
    }

    #
    my($dirUc) = MbgdUserGenomeCommon::getDirUserChromosome($uid, $idUserGenome, $idUserChromosome);
    if ($modNewUserChr) {
        rmtree($dirUc);
        mkpath($dirUc, 0, 0750);
        MbgdUserGenomeCommon::save_mode_chromosome($uid,
                                                   $idUserGenome, $idUserChromosome,
                                                   $modNewUserChr);
    }
    else {
        $modNewUserChr = MbgdUserGenomeCommon::load_mode_chromosome($uid,
                                                                    $idUserGenome, $idUserChromosome);
    }

    my($fileError) = "$dirUc/error.txt";
    my($fileGbk) = "$dirUc/ncbiGbk";
    my($fileGeneTab) = "$dirUc/origGeneTab";
    my($fileProtein) = "$dirUc/origProtein";
    my($fileDna)     = "$dirUc/origDna";
    my($display_view_button) = "";
    my($display_err_button) = "";
    if (-e "$fileError") {
        $display_err_button = qq{<input type="button" value="View Error(s)" onclick="viewErrorFile();">};
    }

    #
    my($file_flg) = 0;
    my($sta_file_gbk) = '';
    if ($modNewUserChr =~ /$MbgdUserGenomeCommon::MODE_USERCHR_genbank/i) {
        FileHandle->new(">>$fileGbk"); # touch
    }
    if (-e "$fileGbk") {
        $display_view_button = qq{<input type="button" value="View Saved Data" onclick="viewGbkFile();">};
        if (-s $fileGbk) {
            $sta_file_gbk = 'Uploaded';
        }
        else {
            $sta_file_gbk = 'Not uploaded';
        }
        $sta_file_gbk .= '<br>';
	$file_flg = 1;
    }

    #
    if (-e "$fileGeneTab" || -e "$fileProtein") {
        $display_view_button = qq{<input type="button" value="View Saved Data" onclick="viewGeneInfoFile();">};
	$file_flg = 1;
    }
    if ($file_flg == 0) {
	$display_view_button = qq{<input type="button" value="View Saved Data" onclick="viewGeneInfoFile();"> <font color="#bbbbbb">&nbsp;&nbsp;This data might be saved using Command Line.</font>};
    }

    #
    my($sta_file_gene_table) = '';
    if ($modNewUserChr =~ /$MbgdUserGenomeCommon::MODE_USERCHR_genetab/i) {
        FileHandle->new(">>$fileGeneTab"); # touch
    }
    if (-e "$fileGeneTab") {
        if (-s $fileGeneTab) {
            $sta_file_gene_table = 'Uploaded';
        }
        else {
            $sta_file_gene_table = 'Not uploaded';
        }
        $sta_file_gene_table .= '<br>';
    }

    #
    my($sta_file_protein) = '';
    if ($modNewUserChr =~ /$MbgdUserGenomeCommon::MODE_USERCHR_proteinseq/i) {
        FileHandle->new(">>$fileProtein"); # touch
    }
    if (-e $fileProtein) {
        if (-s $fileProtein) {
            $sta_file_protein = 'Uploaded';
        }
        else {
            $sta_file_protein = 'Not uploaded';
        }
        $sta_file_protein .= '<br>';
    }

    #
    my($sta_file_dna) = '';
    if ($modNewUserChr =~ /($MbgdUserGenomeCommon::MODE_USERCHR_genetab_proteinseq|$MbgdUserGenomeCommon::MODE_USERCHR_dnaseq)/i) {
        FileHandle->new(">>$fileDna"); # touch
    }
    if (-e $fileDna) {
        if (-s $fileDna) {
            $sta_file_dna = 'Uploaded';
        }
        else {
            $sta_file_dna = 'Not uploaded';
        }
        $sta_file_dna .= '<br>';
    }

    #
    my($name_chr) = $refUserChromosome->{'chromosome_name'};
    if (!$name_chr) {
        $name_chr = "chromosome $idUserChromosome"
    }
    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title></title>
<link rel="stylesheet" href="/css/mymbgd.css" type="text/css" />
<script language="JavaScript" src="/js/mymbgd.js"></script>
<script>
function isChanged() {
    return isChangedFormData(this.document);
}

function checkInputChromosomeInfo() {
    var f = this.document.formUserChromosome;
    var elm;
    var txt;

    elm = f.chromosome_length;
    if (typeof(elm) == 'undefined') {
        return true;
    }

    trim(elm);
    if ((elm.value == '')
     && (typeof(f.file_gbk) != 'undefined' && f.file_gbk.value =='')
     && (typeof(file_dna)   != 'undefined' && f.file_dna.value =='')) {
        alert('Please input Chromosome Length');
        elm.focus();
        return false;
    }

    return true;
}

function submitUserChromosome() {
    var frm = this.document.formUserChromosome;
    var sta;

    sta = checkInputChromosomeInfo();
    if (! sta) {
        return;
    }

    frm.action = '/htbin/recog_build/modUserChromosome.cgi';
    frm.target = '';
    frm.submit();
}

function viewErrorFile() {
    var frm = this.document.formUserChromosome;

    frm.action = '/htbin/recog_build/viewErrorMessage.cgi?id_user_genome='
               + frm.id_user_genome.value
               + '&id_user_chromosome='
               + frm.id_user_chromosome.value;
    frm.target = 'file_error';
    frm.submit();

    return;
}

function viewGbkFile() {
    var frm = this.document.formUserChromosome;

//    if (frm.file_gbk.value =='') {
//        alert('Please choose file(GenBank Format).');
//        frm.file_gbk.focus();
//        return;
//    }

    frm.action = '/htbin/recog_build/viewGbkFile.cgi';
    frm.target = 'file_gbk';
    frm.submit();
}

function viewGeneInfoFile() {
    var frm = this.document.formUserChromosome;

//    if (frm.file_gene_table.value =='') {
//        alert('Please choose file(Gene Information).');
//        frm.file_gene_table.focus();
//        return;
//    }

    frm.action = '/htbin/recog_build/viewGeneInfoFile.cgi?spid='
	+ frm.spid_user_genome.value
//	+ '&view_chromosome='
	+ '&id_user_chromosome='
	+ frm.id_user_chromosome.value;
    frm.target = 'file_gene_table';
    frm.submit();
}

</script>
</head>

<body onload="saveFormData(this.document); updateUserChromosomeList($idUserGenome);">

<form name="formUserChromosome" method="post" action="/htbin/recog_build/modUserChromosome.cgi" enctype="multipart/form-data">

<table bgcolor="#007000" width="100%">
<tr><td><font color="#e8f8e8">User Chromosome $userChromosomeNo</font>
$display_view_button
$display_err_button
        </td>
</tr>
<tr><td>
<table bgcolor="#e8f8e8" width="100%" border>
<tr><th colspan="2" nowrap>Chromosome Name</th>
    <td nowrap>
        <input type="text" name="chromosome_name" value="$name_chr" size="40"></td>
</tr>
EOB

    if ($sta_file_gbk) {
        print <<EOB;
<tr><th nowrap colspan=2>Data in GenBank Format</th>
    <td nowrap>$sta_file_gbk
        <input type="file" name="file_gbk" value="" size="30">
    </td>
</tr>
EOB
    }

    #
    my($n_row) = 3;
    my($html_shape_len) = '';
    if ($modNewUserChr =~ /^$MbgdUserGenomeCommon::MODE_USERCHR_metagenome\:/) {
        $n_row = 0;
    }
    else {
        $html_shape_len = qq{
    <th nowrap>Chromosome Shape</th>
    <td nowrap>
        <input type="radio" name="chromosome_shape" value="circular" $staCircular>Circular
        <input type="radio" name="chromosome_shape" value="linear" $staLinear>Linear
    </td>
</tr>

<tr><th nowrap>Chromosome Length</th>
    <td nowrap>
        <input type="text" name="chromosome_length" value="$refUserChromosome->{'chromosome_length'}" size="20">bp</td>
</tr>
<tr><th nowrap>Sequence Type</th>
    <td nowrap>
        <input type="radio" name="seqtype" value="chromosome" $staChromosome>Chromosome
        <input type="radio" name="seqtype" value="plasmid" $staPlasmid>Plasmid
    </td>
};


    }
    if ($sta_file_gene_table || $modNewUserChr =~ /$MbgdUserGenomeCommon::MODE_USERCHR_genetab/i) {
##        if ($modNewUserChr !~ /$MbgdUserGenomeCommon::MODE_USERCHR_metagenome/) {
            $n_row++;
##        }
    }
    if ($sta_file_protein    || $modNewUserChr =~ /$MbgdUserGenomeCommon::MODE_USERCHR_proteinseq/i) {
        $n_row++;
    }
    if ($sta_file_dna        || $modNewUserChr =~ /$MbgdUserGenomeCommon::MODE_USERCHR_dnaseq/i) {
        $n_row++;
    }

    my($n_col) = 1;
    my($spanned_col);
    if ($n_row > 1) {
        print <<EOB;
<tr><th rowspan="$n_row" nowrap>Separated Files</th>
$html_shape_len
EOB
    	$spanned_col = 1 if (! $html_shape_len);
    }
    else {
        $n_col = 2;
    }

    if ($sta_file_gene_table || $modNewUserChr =~ /$MbgdUserGenomeCommon::MODE_USERCHR_genetab/i) {
##        if ($modNewUserChr !~ /$MbgdUserGenomeCommon::MODE_USERCHR_metagenome/) {

	    print "<tr>" if (! $spanned_col); $spanned_col = 0;
            print <<EOB;
<th nowrap>Gene Information<br> (a tab-delimited file)</th>
    <td nowrap>$sta_file_gene_table
        <input type="file" name="file_gene_table" value="" size="30">
    </td>
</tr>
EOB
##       }
    }

    if ($sta_file_protein || $modNewUserChr =~ /$MbgdUserGenomeCommon::MODE_USERCHR_proteinseq/i) {
	print "<tr>" if (! $spanned_col); $spanned_col = 0;
        print <<EOB;
<th colspan="$n_col" nowrap>Protein Sequences <br>(FASTA format)</th>
    <td colspan="$n_col" nowrap>$sta_file_protein
        <input type="file" name="file_protein" value="" size="30"></td>
</tr>
EOB
    }

    if ($sta_file_dna || $modNewUserChr =~ /$MbgdUserGenomeCommon::MODE_USERCHR_dnaseq/i) {
	print "<tr>" if (! $spanned_col); $spanned_col = 0;
        print <<EOB;
<th nowrap>DNA Sequences <br>(FASTA format)</th>
    <td nowrap>$sta_file_dna
        <input type="file" name="file_dna" value="" size="30"></td>
</tr>
EOB
    }
    my($saveButtonStat, $updateButton);
print STDERR "$uid, $idUserGenome\n";
print STDERR "stat=", MbgdUserGenomeCommon::getUserGenomeConvertingStatus($uid, $idUserGenome), "\n";

    if (! MbgdUserGenomeCommon::getUserGenomeConvertingStatus($uid, $idUserGenome)) {
	$saveButtonStat = 'disabled';
	$updateButton = qq{<input type="button" value="Check Update"  onclick="updateUserGenomeList(); updateUserChromosome($idUserGenome);">};
    }

    print <<EOB;
</table>
</td></tr>
</table>
<!-- (*) Requirement -->

<div id="btn">
<input type="button" name="" value="Save" $saveButtonStat onclick="submitUserChromosome();">
$updateButton
</div>

<input type="hidden" name="spid_user_genome" value="$spidUserGenome">
<input type="hidden" name="id_user_genome" value="$idUserGenome">
<input type="hidden" name="id_user_chromosome" value="$idUserChromosome">
</form>

</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($WWW) = MBGD::WWW->new;
    my($uid) = $WWW->uid();

    my($key);

    #
    my($cgi) = new CGI();

    my($formOpt) = {};

    $key = 'id_user_genome';
    $formOpt->{"$key"} = $cgi->param($key);

    $key = 'id_user_chromosome';
    $formOpt->{"$key"} = $cgi->param($key);

    $key = 'chromosome_data_type';
    $formOpt->{"$key"} = $cgi->param($key);

    modUserChromosomeWin($uid, $formOpt);

    exit(0);
}
###############################################################################
1;#
###############################################################################
