#!/usr/bin/perl -s
use strict;
use CGI;
use File::Path;
use MBGD::DB;
use RecogProjectCommon;
require "MBGD_Conf.pl";

$main::url_spec        = "http://mbgd.genome.ad.jp/data/species";
$main::url_tax         = "http://mbgd.genome.ad.jp/data/tax";
$main::url_genome      = "http://mbgd.genome.ad.jp/htbin/RECOG/getData?table=genome";
$main::url_gold        = "http://mbgd.genome.ad.jp/htbin/RECOG/getData?table=gold";
$main::url_gold_mbgd   = "http://mbgd.genome.ad.jp/htbin/RECOG/getData?table=xref_gold_mbgd";

###############################################################################
#
sub organism_selection_recog {
    my($formOpt) = shift;

    #
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($dbname) = $main::DBNAME_ACCUM;
    my($db) = MBGD::DB->new($dbname);

    #
#    print STDERR "Update spid.tab.dist\n";
#    my($u) = "$main::url_spec/spid.tab";
#    my($fileSpidDist) = "$main::FILE_spidtab.dist";
#    my($cmd) = "$main::CMD_curl -s -L -o $fileSpidDist $u";
#    system("$cmd");

    #
    my($dir_proj) = sprintf("%s/work/recog_build-%d", $ENV{'RECOG_HOME'},
                                                      $formOpt->{'project_id'});

    #
    $ENV{'QUERY_STRING'} = join('&', "mode=recog_build",
                                     "project_id=" . $formOpt->{'project_id'},
                                );
    my($cmd) = "../organism_selection.cgi";
    exec($cmd);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    #
    my($formOpt) = {};
    foreach my$key ('project_id') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    organism_selection_recog($formOpt);
}

###############################################################################
1;#
###############################################################################
