#!/usr/bin/perl -s
use strict;
use CGI;
use FileHandle;
use MBGD::WWW;
use MbgdUserGenomeCommon;
use RecogBuild;
use RecogProjectCommon;

###############################################################################
#
sub printGeneEntries {
    my($spid) = shift;
    my($fileGeneTab) = shift;
    my($fileProtein) = shift;
    my($chr_ref) = shift;

    #
	
    my(@line_list);
    my($fhg) = FileHandle->new("$fileGeneTab");
    if ($fhg) {
        @line_list = $fhg->getlines();
        $fhg->close();
    }

    #
    my(%hash_protseq);
    #my(%hash_product); out of use maybe...
    my(%hash_protseq_out);
    if (-e $fileProtein) {
        my($fhp) = FileHandle->new("$fileProtein");
        if ($fhp) {
            my($id);
            my($product);
            while(my$line0 = $fhp->getline()) {
                $line0 =~ s#[\r\n]*$##;
                foreach my$line (split(/\r/, $line0)) {
                    $line =~ s#[\r\n]*$##;

                    if ($line =~ /^>\s*(\S+)\s*(.*)/) {
                        $id = $1;
                        $product = $2;

                        if ($id =~ /\:/) {
                            $id =~ s#^.+\:##;
                        }
                        $hash_protseq{"$id"} = '';
                        #$hash_product{"$id"} = $product;
                    }
                    else {
                        $hash_protseq{"$id"} .= $line;
                    }
                }
            }
            $fhp->close();
        }
    }

    #
    my($disp_entries) = '';
    my($n_cds) = 0;
    my($n_cds_protseq) = 0;
    my($n_protseq) = scalar(keys(%hash_protseq));
    my($name, $gene, $from, $to, $dir, $type, $descr);
    my($chrAcc, $location, $transl_table, $codon_start, $protid, $gi, $geneid);
    my($use_user_data) = 0;
    my(@cols_user) = split(/\s/, 'id gene dummy1 locus from to dir join type descr');
    my(@cols_user7) = split(/\s/, 'id gene from to dir type descr');
    my($ln, $header);
    foreach my$line0 (@line_list) {
        foreach my$line (split(/\r/, $line0)) {

            next if ($line =~ /^\s*$/);

            if ($line =~ /^\s*#/) {
                if ($line =~ /format\tuser_data/) {
                    $use_user_data = 1;
                } elsif ($line =~ /cols\t(.+)/) {
                    @cols_user = split(/\s/, $1);
		} elsif ($line =~ /#(.+)/) {
                    @cols_user = split(/\s/, $1);
                } elsif ($line =~ /#(.$)$/) {
			my($line_head) = $1;
			@cols_user = split(/\s/, $line_head);
		}
		$header = 1;
                next;
            }

            $line =~ s#[\r\n]*$##;

            my(@data_gene) = split(/\t/, $line);
	    if (! $header && $ln==0) {
		if (@data_gene <= 7) {
			## assuming basic (7 column) format
			@cols_user = @cols_user7;
		}
	    	$ln++;
	    }
            my($idx) = 0;
            foreach my $k (@cols_user) {
                if ($k =~ /^id$/i) {
                    $name = $data_gene[$idx];
                }
                elsif ($k =~ /^gene$/i) {
                    $gene = $data_gene[$idx];
                }
                elsif ($k =~ /^from$/i) {
                    $from = $data_gene[$idx];
                }
                elsif ($k =~ /^to$/i) {
                    $to = $data_gene[$idx];
                }
                elsif ($k =~ /^dir$/i) {
                    $dir = $data_gene[$idx];
                }
                elsif ($k =~ /^type$/i) {
                    $type = $data_gene[$idx];
                }
                elsif ($k =~ /^descr$/i) {
                    $descr = $data_gene[$idx];
                }
                elsif ($k =~ /^location$/i) {
                    $location = $data_gene[$idx];
                }
                elsif ($k =~ /^transl_table$/i) {
                    $transl_table = $data_gene[$idx];
                }
                elsif ($k =~ /^codon_start$/i) {
                    $codon_start = $data_gene[$idx];
                }
                elsif ($k =~ /^protid$/i) {
                    $protid = $data_gene[$idx];
                }
                elsif ($k =~ /^gi$/i) {
                    $gi = $data_gene[$idx];
                }
                elsif ($k =~ /^geneid$/i) {
                    $geneid = $data_gene[$idx];
                }
                $idx++;
            }
            if ($type =~ /^\s*$/) {
                $type = 'CDS';
            }

            if (($from == -1) && ($to == -1)) {
                next;
            }

            $disp_entries .= "<tr>\n";
            $disp_entries .= "<td>$name</td>";
            $disp_entries .= "<td>$gene</td>";

            # $B%3%s%^$rA^F~$7=PNO(B
            while ($from =~ s#^([\+\-]?\d+)(\d{3})#$1,$2#) { ; };
            $disp_entries .= "<td align=\"right\">$from</td>";

            # $B%3%s%^$rA^F~$7=PNO(B
            while ($to =~ s#^([\+\-]?\d+)(\d{3})#$1,$2#) { ; };
            $disp_entries .= "<td align=\"right\">$to</td>";

            #
            $disp_entries .= "<td align=\"right\">$dir</td>";
            $disp_entries .= "<td>$type</td>";
            $disp_entries .= "<td>$descr</td>";

            #
            my($style) = '';
            if ($type =~ /^cds$/i) {
                $n_cds++;
                if ($hash_protseq{"$name"} =~ /^\s*$/) {
                    $style = 'background-color:red;';
                }
                else {
                    $n_cds_protseq++;
                }
            }
            $disp_entries .= "<td style=\"$style\">" . $hash_protseq{"$name"} . "</td>";
            $disp_entries .= "\n";
            $disp_entries .= "</tr>\n";

            #
            $hash_protseq_out{"$name"} = 1;
        }
    }

    #
    ## output genes that have only protein sequence data
    my($disp_entries_protseq_only) = '';
    my($style) = 'background-color:#ffffcc;';
    my(@name_list) = keys(%hash_protseq);
    foreach my$name (sort(@name_list)) {
        next if ($hash_protseq_out{"$name"});


        $disp_entries_protseq_only .= "<tr>"
                                    . "<td>$name</td>"
                                    . "<td></td>" # gene
                                    . "<td style=\"$style\"></td>" # from
                                    . "<td style=\"$style\"></td>" # to
                                    . "<td style=\"$style\"></td>" # dir
                                    . "<td></td>" # type
                                    . "<td></td>" # descr
                                    . "<td>" . $hash_protseq{"$name"} . "</td>"
                                    . "</tr>\n";
    }
    return {
	disp_entries => $disp_entries,
	disp_entries_protseq_only => $disp_entries_protseq_only,
	n_cds => $n_cds,
	n_cds_protseq => $n_cds_protseq,
	n_protseq => $n_protseq,
    };
}

sub printGeneEntriesAll {
    my($dir_chr) = shift;
    my($spid) = shift;
    my($fileGeneTab) = shift;
    my($fileProtein) = shift;
    my($chr_ref) = shift;
    my($disp_entries);
    my($n_cds, $n_cds_protseq, $n_protseq);
    my($ret);

    if (-e $fileProtein) {
	$ret = printGeneEntries($spid, $fileGeneTab, $fileProtein);
	$disp_entries =
		$ret->{disp_entries} . $ret->{disp_entries_protseq_only};
	($n_cds, $n_cds_protseq, $n_protseq) = (
		$ret->{n_cds}, $ret->{n_cds_protseq}, $ret->{n_protseq});
    } else {
	opendir(D, "$dir_chr") || die "Can't open directory $dir_chr\n";
	while (my $f = readdir(D)) {
		next if ($f =~ /^\./);
		next if ($f !~ /^(.*)\.protseq$/);
		my($uc_id) = $1;
    		my($fileGeneTab) = "$dir_chr/$uc_id.gene";
		my($fileProtein) = "$dir_chr/$uc_id.protseq";
    		$ret = printGeneEntries($spid, $fileGeneTab, $fileProtein);
		$disp_entries .= 
			$ret->{disp_entries} . $ret->{disp_entries_protseq_only};
		$n_cds += $ret->{n_cds};
		$n_cds_protseq += $ret->{n_cds_protseq};
		$n_protseq += $ret->{n_protseq};
	}
    }
    #
    print "<h2>Your Saved Data (" . $chr_ref->{'name'} . ")</h2>\n";
    print "<b>Please check whether the data have been correctly saved.</b><br>\n";
    print "<table border>\n";
    print "<tr><th>CDS</td>\n";
    print "    <td align=\"right\">$n_cds</td>\n";
    print "<tr/>\n";
    print "<tr><th>Protein Sequence(Linked GeneTab)</td>\n";
    print "    <td align=\"right\">$n_cds_protseq</td>\n";
    print "<tr/>\n";
    print "<tr><th>Protein Sequence(Upload)</td>\n";
    print "    <td align=\"right\">$n_protseq</td>\n";
    print "<tr/>\n";
    print "</table>\n";
    print "<table style=\"empty-cells:show;\" border>\n";
    print "<tr>\n";
    print "<th>Name</th>";
    print "<th>Gene</th>";
    print "<th>From</th>";
    print "<th>To</th>";
    print "<th>Direction</th>";
    print "<th>Type</th>";
    print "<th>Description</th>";
    print "<th>Protein Sequence</th>";
    print "</tr>\n";
    print $disp_entries;
##    print $disp_entries_protseq_only;
    print "</table>\n";

    return;
}

###############################################################################
#
sub viewGeneInfoFile {
    my($uid) = shift;
    my($formOpt) = shift;
    my($spid)  = $formOpt->{'spid_user_genome'};
    my($uc_id) = $formOpt->{'id_user_chromosome'};
    my($dir) = sprintf("%s/species/%s/gm", $ENV{'MBGD_HOME'}, $spid);
    my($dir_chr) = "$dir/data";
    my($fileGeneTab) = "$dir_chr/$uc_id.gene";
    my($fileProtein) = "$dir_chr/$uc_id.protseq";

    if (! -e $fileGeneTab || -z $fileGeneTab) {
	my($tmp) = glob($dir_chr."/*_chr".$uc_id.".gene");
	$fileGeneTab = $tmp;
    }

    if (! -e $fileProtein || -z $fileProtein) {
	my($tmp) = glob($dir_chr."/*_chr".$uc_id.".protseq");
	$fileProtein = $tmp;
    }
    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print <<"END_HTML";
<html>
<head>
<title></title>
<link rel="stylesheet" href="/css/mbgd.css" type="text/css" />
</head>
<body>
END_HTML

    my($chr_ref) = RecogBuild::load_user_chromosome_list($spid, $uc_id);
    printGeneEntriesAll($dir_chr, $spid, $fileGeneTab, $fileProtein, $chr_ref);

    print <<"END_HTML";
</body>
</html>
END_HTML

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($WWW) = MBGD::WWW->new;
    my($uid) = $WWW->uid();

    my($key);

    #
    my($cgi) = new CGI();

    my($formOpt) = {};
#    foreach my$key ('spid', 'view_chromosome') {
    foreach my$key ('spid_user_genome', 'id_user_chromosome') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    viewGeneInfoFile($uid, $formOpt);
}

###############################################################################
1;#
###############################################################################
