#!/usr/bin/perl -s
use strict;
use MBGD::WWW;
use MbgdUserGenomeCommon;

###############################################################################
#
sub viewUserGenomeListWin {
    my($uid) = shift;
    my(@listUserGenome);
    my($refUserGenome);

    #
    MbgdUserGenomeCommon::saveDbname($uid);

    #
    my(@gid_list) = MbgdUserGenomeCommon::getGidList($uid);
    foreach my$idUserGenome (sort @gid_list) {
        my($dirUg) = MbgdUserGenomeCommon::getDirUserGenome($uid,
                                                            $idUserGenome);
        if (! -e $dirUg) {
#            next;
        	my($dirUgReady) = MbgdUserGenomeCommon::getDirUserGenomeReady($uid, $idUserGenome);
		$refUserGenome = MbgdUserGenomeCommon::loadUserGenomeInfoFromGmFile($uid, $idUserGenome);
		
        } else {

        	$refUserGenome = MbgdUserGenomeCommon::loadUserGenomeInfo($uid,
                                                                  $idUserGenome);
	}
        push(@listUserGenome, $refUserGenome);
    }

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title></title>
<link rel="stylesheet" href="/css/mymbgd.css" type="text/css" />
<script>
function addUserGenome() {
    var win;

    win = open('', 'mod_user_genome');
    win.location = '/htbin/recog_build/modUserGenomeWin.cgi?id_user_genome=-1';

    win = open('', 'list_user_chromosome');
    win.location = '/recog_build/blank.html';

    win = open('', 'mod_user_chromosome');
    win.location = '/recog_build/blank.html';
}

function deleteUserGenome(gid) {
    var win;

    var sta = confirm('Delete this genome.\\nAre you sure?');
    if (! sta) {
        return;
    }

    win = open('', 'mod_user_genome');
    win.location = '/htbin/recog_build/delUserGenome.cgi?id_user_genome=' + gid;
}
</script>
</head>

<body>
<form>
<table bgcolor="#007000" width="100%">
<tr><td><font color="#e8f8e8">User Genome List</font></td>
</tr>
<tr><td>
<table bgcolor="#e8f8e8" width="100%" border>
EOB

    if (scalar(@listUserGenome) == 0) {
        # Ͽ줿 UserGenome ̵
        print <<EOB;
<tr><td>No User Genome</td></tr>
EOB
    }
    else {
        print <<EOB;
<tr><th nowrap>Name</th>
    <th width="3%" nowrap>Status</th>
    <th width="3%" nowrap>Del</th>
</tr>
EOB

        # ϿƤ UserGenome ɽ
        foreach $refUserGenome (@listUserGenome) {
            my($gid) = $refUserGenome->{'id_user_genome'};
	    print "<tr><td nowrap>";

	    if (! $gid && $refUserGenome->{'spid'}) {
		# set gid from spid
		$gid = $refUserGenome->{'spid'};
		$gid =~ s/gu0*//;
	    }

	    if ($gid) {
            	print qq{<a href="/htbin/recog_build/modUserGenomeWin.cgi?id_user_genome=$gid" target="mod_user_genome">};
	    }
            print $refUserGenome->{'abbreviation_name'}," ",
            	$refUserGenome->{'strain'},
		"\n";
	    if ($gid) {
		print "</a>";
	    }
	    print "</td>\n";
            print <<EOB;
    <td align="center" nowrap>$refUserGenome->{'status'}</td>
    <td align="center" nowrap>
        <input type="button" value="Del" onclick="deleteUserGenome($gid);"></td>
</tr>
EOB
            if ($refUserGenome->{'status'} =~ /^Ok$/i) {
		## Start conversion from gu to gm data
                MbgdUserGenomeCommon::conv_ug2gm($uid, $gid);
            }
        }
    }

    print <<EOB;
</table>
</td></tr>
</table>

<input type="button" value="Create New Genome" onclick="addUserGenome();">
<input type="button" name="btn_close" value="Close" onclick="top.close();">
EOB

    print <<EOB;
</form>
</div>

</body>
</html>
EOB
}

###############################################################################
if ($0 eq __FILE__) {
    my($WWW) = MBGD::WWW->new;
    my($uid) = $WWW->uid();

    #
    viewUserGenomeListWin($uid);

    exit(0);
}

###############################################################################
1;#
###############################################################################
