#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;

###############################################################################
sub create_project {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($auth) = RECOG::RecogProject->new();
    my($sta) = $auth->permit_project_user($user,
                                          $RECOG::RecogProject::ID_PRJ_system,
                                          $RECOG::RecogProject::ACT_ADD_PRJ);
    if (!$sta) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($msg);
    my($id_proj);

    my($project_name) = $form_opt->{'project_name'};
    my($project_descr) = $form_opt->{'project_descr'};
    my(@project_species) = @{$form_opt->{'project_species'}};
    my($sta) = $auth->exists_project_name($user, $project_name);
    if ($sta == 1) {
        # Found project!
        $msg = "Already exists. [$project_name]";
    }
    elsif ($sta == 2) {
	$msg = "Invalidated name. [$project_name]";
    }
    else {
        #
        my($opt) = {};
        $opt->{'descr'} = $project_descr;
        $id_proj = $auth->add_project($user, $project_name, $opt);
        $auth->set_project_species($user, $id_proj, @project_species);

        $msg = "Success.";
    }

    print "Content-type: text/html\n";
    print "\n";

    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />\n};
    print <<EOB;
<script>
this.top.opener.location.reload();
</script>
EOB

    print "</htad>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Create project</h1>\n";
    print $msg;
    print <<EOB;
<form method="post" action="/htbin/recog_project/list_project_user_win.cgi">
<input type="hidden" name="project_id" value="$id_proj">
<input type="button" name="btn_close" value="Close" onclick="self.close();">
<input type="submit" name="btn_edit_members" value="Edit members">
</form>
EOB
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('project_name', 'project_descr') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    my($key) = 'project_species';
    $form_opt->{"$key"} = [];
    push(@{$form_opt->{"$key"}}, $cgi->param($key));

    create_project($form_opt);
}

###############################################################################
1;#
###############################################################################
