#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;
require 'libMBGDaxes.pl';
require "InfoSpec.pl";

###############################################################################
#
sub get_base_cluster_conf_id {
    my($dir) = shift;

    my($id);
    for ($id = 1; ; $id++) {
        my($file) = "$dir/$id.conf";

        if (! -e $file) {
            return $id;
        }
    }
}

###############################################################################
#
sub edit_base_cluster_conf_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};

    #
    my($dir_base_cluster) = sprintf("%s/database.work/base_cluster/%d.d", $ENV{'RECOG_HOME'}, $project_id);
    my($base_cluster_conf_id) = $form_opt->{'base_cluster_conf_id'};
    if (!$base_cluster_conf_id) {
        $base_cluster_conf_id = get_base_cluster_conf_id($dir_base_cluster);
    }

    my($auth) = RECOG::RecogProject->new();

    #
    my(%spid_hash, %spec_hash);
    my($proj_ref) = $auth->get_project($user, $project_id);
    foreach my$spid (@{$proj_ref->{'PROP'}->{'spid_list'}}) {
        my($spec) = spid2sp($spid);
        $spid_hash{"$spid"} = 1;
        $spec_hash{"$spec"} = 1;
    }

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Edit base cluster condition</h1>\n";

    #
    if (!$proj_ref) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    #
    my($file_conf) = "$dir_base_cluster/$base_cluster_conf_id.conf";
    my($conf_ref) = RecogProjectCommon::load_base_cluster_conf($file_conf);

    #
    my($dbname) = $main::DBNAME_WORK;
    my($db) = MBGD::DB->new($dbname);

    print <<EOB;
<form name="frm_del_base_cluster_conf" method="post" action="/htbin/recog_project/delete_base_cluster_conf.cgi">
<input type="hidden" name="project_id" value="$project_id">
<input type="hidden" name="base_cluster_conf_id" value="$base_cluster_conf_id">
</form>

<form name="frm_base_cluster_conf" method="post" action="/htbin/recog_project/edit_base_cluster_conf.cgi">
<input type="hidden" name="project_id" value="$project_id">
<input type="hidden" name="base_cluster_conf_id" value="$base_cluster_conf_id">
EOB

    #
    my(%selected_spec);
    foreach my$spec (split(/,/, $conf_ref->{'ingroup'})) {
        $selected_spec{"$spec"} = 'selected';
    }

    # ingroup(=species)
    my($opt) = {};
    $opt->{'columns'} = '*';
    $opt->{'order'} = 'sp';
    my($sel_opt) = '';
    my($res) = $db->select_fetch('genome', $opt);
    foreach my$ref (@{$res->{'INFO'}}) {
        my($sp) = $ref->{'sp'};

        next if (!exists($spec_hash{"$sp"}));

        my($name) = $ref->{'orgname'};
        my($strain) = $ref->{'strain'};
        if ($strain !~/^\s*$/) {
            $strain = "($strain)";
        }
        my($sta) = $selected_spec{"$sp"};
        $sel_opt .= "<option value=\"$sp\" $sta>[$sp] $name$strain</option>\n";
    }

    print qq{<table><tr><td valign="top">};
    print qq{<select name="ingroup" size="30" multiple>};
    print $sel_opt;
    print qq{</select>};
    print qq{</td><td>};

    #
    $conf_ref->{'eval'} = 0.001 if (!$conf_ref->{'eval'});
    $conf_ref->{'score'} = 60 if (!$conf_ref->{'score'});

    #
    $conf_ref->{'besthit'} = 'none' if (!$conf_ref->{'besthit'});
    my(%sta_besthit_none) = ( 'none'     => 'checked' );
    my(%sta_besthit_bi)   = ( 'bidirec'  => 'checked' );
    my(%sta_besthit_uni)  = ( 'unidirec' => 'checked' );
    my($sta_besthit_none) = $sta_besthit_none{"$conf_ref->{'besthit'}"};
    my($sta_besthit_bi)   = $sta_besthit_bi{"$conf_ref->{'besthit'}"};
    my($sta_besthit_uni)  = $sta_besthit_uni{"$conf_ref->{'besthit'}"};

    #
    $conf_ref->{'sim_measure'} = 'score' if (!$conf_ref->{'sim_measure'});
    my(%sta_sim_score)    = ( 'score'    => 'checked' );
    my(%sta_sim_pam)      = ( 'pam'      => 'checked' );
    my(%sta_sim_identity) = ( 'identity' => 'checked' );
    my($sta_sim_score)    = $sta_sim_score{"$conf_ref->{'sim_measure'}"};
    my($sta_sim_pam)      = $sta_sim_pam{"$conf_ref->{'sim_measure'}"};
    my($sta_sim_identity) = $sta_sim_identity{"$conf_ref->{'sim_measure'}"};

    #
    $conf_ref->{'clustmode'} = 'combined' if (!$conf_ref->{'clustmode'});
    my(%sta_clustmode_combined)   = ( 'combined'  => 'checked' );
    my(%sta_clustmode_homology)   = ( 'homology'  => 'checked' );
    my(%sta_clustmode_orthology)  = ( 'orthology' => 'checked' );
    my($sta_clustmode_combined)   = $sta_clustmode_combined{"$conf_ref->{'clustmode'}"};
    my($sta_clustmode_homology)   = $sta_clustmode_homology{"$conf_ref->{'clustmode'}"};
    my($sta_clustmode_orthology)  = $sta_clustmode_orthology{"$conf_ref->{'clustmode'}"};


    print <<EOB;
<table border>
  <tr><th colspan="3">Options</th></tr>
  <tr><td> eval    </td>
      <td><input type="text" name="eval" value="$conf_ref->{'eval'}" /></td>
      <td> Cutoff BLAST E-value </td></tr>

  <tr><td> score    </td>
      <td><input type="text" name="score" value="$conf_ref->{'score'}" /></td>
      <td> Cutoff DP score </td></tr>

  <tr><td> ident    </td>
      <td><input type="text" name="ident" value="$conf_ref->{'ident'}" /></td>
      <td> Cutoff percent identity </td></tr>

  <tr><td> pam    </td>
      <td><input type="text" name="pam" value="$conf_ref->{'pam'}" /></td>
      <td> Cutoff PAM distance </td></tr>

  <tr><td> besthit    </td>
      <td><label><input TYPE="radio" NAME="besthit" VALUE="none" $sta_besthit_none>none</label>
          <label><input TYPE="radio" NAME="besthit" VALUE="bidirec" $sta_besthit_bi>bidirec</label>
          <label><input TYPE="radio" NAME="besthit" VALUE="unidirec" $sta_besthit_uni>unidirec</label>
      </td>
      <td> Best hit criterion </td></tr>

  <tr><td> ratiocut    </td>
      <td><input type="text" name="ratiocut" value="" /></td>
      <td> Cutoff ratio of the score against the best </td></tr>

  <tr><td> sim_measure (-S / -d)    </td>
      <td><label><input type="radio" name="sim_measure" value="score" $sta_sim_score>score</label>

          <label><input type="radio" name="sim_measure" value="pam" $sta_sim_pam>pam</label>
          <label><input type="radio" name="sim_measure" value="identity" $sta_sim_identity>identity</label>
      </td>
      <td> use similarity or distance as a measure of relatedness </td></tr>
<!--
  <tr><td> -c#   </td>
      <td></td>
      <td> Cutoff DP score / Cutoff PAM distance </td></tr>
-->
  <tr><td> -ci#   </td>
      <td><input type="text" size="20" name="cutoff_ingroup" /></td>
      <td> Cutoff DP score / Cutoff PAM distance / Cutoff IDENTITY for in-group</td></tr>

  <tr><td> missdist(-m#)   </td>
      <td><input type="text" size="20" name="missdist" value="$conf_ref->{'missdist'}" /></td>
      <td> score/distance for missing relationships (m &lt; c) </td></tr>

  <tr><td> missdist_ratio(-mr#)  </td>
      <td><input type="text" size="20" name="missdist_ratio" value="$conf_ref->{'missdist_ratio'}" /></td>
      <td> specify a missing score as a ratio to c (0 &lt; mr &lt; 1) [0.95] </td></tr>

  <tr><td> cutoff2(-C#)   </td>
      <td><input type="text" size="20" name="cutoff2" value="$conf_ref->{'cutoff2'}" /></td>
      <td> cutoff score for domain split (c &le; C) </td></tr>

  <tr><td> coverage2(-V#)   </td>
      <td><input type="text" size="20" name="coverage2" value="$conf_ref->{'coverage2'}" /></td>
      <td> alignment coverage for domain split (0 &le; V &le; 1) </td></tr>
<!--
  <tr><td> (-n#)   </td>
      <td>1</td>
      <td> minimum # of organisms in clusters to be output </td></tr>

  <tr><td> (-ne#)  </td>
      <td>1</td>
      <td> minimum # of entries in clusters to be output </td></tr>
-->
  <tr><td> phylocut(-p#)   </td>
      <td><input type="text" size="20" name="phylocut" value="$conf_ref->{'phylocut'}" /></td>
      <td> ratio of phylogenetic pattern overlap for tree cutting [0.5] </td></tr>

  <tr><td> clustmode(-H)    </td>
      <td><label><input type="radio" name="clustmode" value="combined"  $sta_clustmode_combined>combined</label>
          <label><input type="radio" name="clustmode" value="homology"  $sta_clustmode_homology>homology</label>
          <label><input type="radio" name="clustmode" value="orthology" $sta_clustmode_orthology>orthology</lavel>
      </td>
      <td> homology clustering (i.e. skip the tree cutting) </td></tr>
<!--
  <tr><td> taxonlevel(-t)    </td>
      <td><select name="taxonlevel">

          <option VALUE="none" SELECTED>none
          <option VALUE="species" >species
          <option VALUE="genus" >genus
          <option VALUE="family" >family
          <option VALUE="order" >order
          </select>
      <td> Phylogenetically related organisms </td></tr>
-->
  <tr><td> adjincl(-ai#)  </td>
      <td><input type="text" size="20" name="adjincl" value="$conf_ref->{'adjincl'}" /></td>
      <td> member overlap for absorbing adjacent small clusters (0 &le; ai &le; 1) </td></tr>

  <tr><td> adjovlp(-ao#)  </td>
      <td><input type="text" size="20" name="adjovlp" value="$conf_ref->{'adjovlp'}" /></td>
      <td> member overlap for merging adjacent clusters (0 &le; ao &le; ai) </td></tr>

  <tr><td> Ohorizweight  </td>
      <td><input type="text" size="20" name="horizweight" value="$conf_ref->{'horizweight'}" /></td>
      <td> relative weight for horiz. transfer (0 &le; x &le; 1) [0] </td></tr>
</table>
EOB
    print qq{</td></table>};
    print qq{<input type="button" name="btn_save" value="Delete" onclick="del_base_cluster($base_cluster_conf_id);">};
    print qq{<input type="submit" name="btn_save" value="Save" onclick="">};
    print qq{<input type="button" name="btn_close" value="Close" onclick="window.close();">};
    print qq{</form>};

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_id', 'base_cluster_conf_id');
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    edit_base_cluster_conf_win($form_opt);
}

###############################################################################
1;#
###############################################################################
