#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;

###############################################################################
sub edit_project {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($id_proj) = $form_opt->{'project_id'};
    my($descr_proj) = $form_opt->{'project_descr'};
    my($create_default_cluster) = $form_opt->{'create_default_cluster'};

    #
    my($auth) = RECOG::RecogProject->new();
    my($proj_ref) = $auth->get_project($user, $id_proj);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />\n};
    print <<EOB;
<script>
//this.top.opener.location.reload();
</script>
EOB
    print "</htad>\n";
    print "<body>\n";
    print qq{<div style="text-align:right;">[ $user ]</div>\n};
    print "<h1>Edit project</h1>\n";

    #
    if (!$proj_ref) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    #
    if (exists($form_opt->{'species'})) {
        my(@project_species) = @{$form_opt->{'species'}};
        $auth->set_project_species($user, $id_proj, @project_species);
    }
    $auth->set_project_descr($user, $id_proj, $descr_proj);
    $auth->set_project_create_default_cluster($user, $id_proj, $create_default_cluster);

    #

    print <<EOB;
<script>
this.top.opener.location.reload();
</script>
EOB
    print "Done.<br>\n";
    print qq{<input type="button" name="btn_close" value="Close" onclick="window.close();">};
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_id',
                     'project_descr',
                     'create_default_cluster',
                    );
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    my($key) = 'species';
    my($sta) = $cgi->EXISTS($key);
    if ($sta) {
        $form_opt->{"$key"} = [];
        push(@{$form_opt->{"$key"}}, $cgi->param($key));
    }

    edit_project($form_opt);
}

###############################################################################
1;#
###############################################################################
