#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;

###############################################################################
#
sub exists_project {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    my($project_name) = $form_opt->{'project_name'};
    my($auth) = RECOG::RecogProject->new();
    my($sta) = $auth->exists_project_name($user, $project_name);

    print "Content-type: text/html\n";
    print "\n";
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />\n};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Project name</h1>\n";
    if ($sta) {
        print "Already used this project name. [$project_name]\n";
    }
    else {
        print "This project name is free. [$project_name]\n";
    }

    print qq{<input type="button" name="btn_close" value="Close" onclick="self.close();">\n};
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('project_name') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    exists_project($form_opt);
}

###############################################################################
1;#
###############################################################################
