#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub get_gene_prop_type {
    my($ref) = shift;

    #
    my($type_val) = 'c_val';
    if ($ref->{'type'} =~ /^num$/i) {
        $type_val = 'n_val';
    }

    return $type_val;
}

###############################################################################
#
sub print_gene_prop_head {
    my($prop_name) = shift;
    my($ref) = shift;

    #
    $prop_name .= '(';
    $prop_name .= $ref->{'type'};
    if ($ref->{'elm_ext'}) {
        $prop_name .= "(" . $ref->{'elm_ext'} . ")";
    }
    if ($ref->{'is_multi'}) {
        $prop_name .= ",Multi";
    }
    $prop_name .= ')';

    print join("\t", 'sp', 'locustag', $prop_name), "\n";

    return;
}

###############################################################################
#
sub print_gene_prop {
    my($sth) = shift;
    my($type_val) = shift;

    my($results) = {};
    while (my$ref=$sth->fetchrow_hashref()) {
        my($spec) = $ref->{'sp'};
        my($name) = $ref->{'name'};
        if ($results->{"$spec"}->{"$name"} ne '') {
            $results->{"$spec"}->{"$name"} .= ';';
        }
        $results->{"$spec"}->{"$name"} .= $ref->{"$type_val"};
    }

    my(@spec_list) = sort(keys(%{$results}));
    foreach my$spec (@spec_list) {
        my(@name_list) = sort(keys(%{$results->{"$spec"}}));
        foreach my$name (@name_list) {
            my($val) = $results->{"$spec"}->{"$name"};
            print join("\t", $spec, $name, $val), "\n";
        }
    }

    return;
}

###############################################################################
#
sub get_gene_prop {
    my($form_opt) = shift;

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($user_name) = $ENV{'REMOTE_USER'};
    my($uid) = RecogProjectCommon::exists_user_name($db, $user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($prop_name) = $form_opt->{'prop_name'};
    my($gene_prop_info_ref) = RecogProjectCommon::get_gene_prop_info($db, $prop_name);
    if (!$gene_prop_info_ref) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($type_val) = get_gene_prop_type($gene_prop_info_ref);
    my(@spec_list) = split(',', $form_opt->{'spec'});

    #
    my($gene_prop_ref) = {};
    my($tab) = 'gene_prop';
    my($where) = "prop_name=?";
    my($order) = "name";
    if (scalar(@spec_list) == 0) {
        my($sql) = "select * from $tab where $where order by $order";
        my($sth) = $db->prepare($sql);

        #
        $sth->execute($prop_name);

        #
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        print_gene_prop_head($prop_name, $gene_prop_info_ref);
        print_gene_prop($sth, $type_val);
    }
    else {
        $where .= " and sp=?";
        my($sql) = "select * from $tab where $where order by $order";
        my($sth) = $db->prepare($sql);

        #
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        print_gene_prop_head($prop_name, $gene_prop_info_ref);
        foreach my$spec (@spec_list) {
            $sth->execute($prop_name, $spec);
            print_gene_prop($sth, $type_val);
        }
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('prop_name', 'spec');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $form_opt->{"$key"} = $val;
    }

    get_gene_prop($form_opt);
}

###############################################################################
1;#
###############################################################################
