#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub get_gene_set {
    my($form_opt) = shift;

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($user_name) = $ENV{'REMOTE_USER'};
    my($uid) = RecogProjectCommon::exists_user_name($db, $user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($set_name) = $form_opt->{'set_name'};

    #
    my($gene_set_ref) = {};
    my($tab) = 'gene_set';
    my($where) = "set_name=?";
    my($sql) = "select * from $tab where $where";
    my($sth) = $db->prepare($sql);

    #
    my($results) = {};
    $sth->execute($set_name);
    if ($sth->rows() == 0) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }
    my($ref) = $sth->fetchrow_hashref();

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);
    print $ref->{'set_val'};

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('set_name');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $form_opt->{"$key"} = $val;
    }

    get_gene_set($form_opt);
}

###############################################################################
1;#
###############################################################################
