#!/usr/bin/perl -s
use strict;
use CGI;
use IO::Dir;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;
require 'libMBGDaxes.pl';

###############################################################################
sub print_html_base_cluster {
    my($project_id) = shift;
    my($base_cluster_conf_id) = shift;
    my($file_base_cluster) = shift;

    my($ref) = RecogProjectCommon::load_base_cluster_conf("$file_base_cluster");
    if (!$ref) {
        return;
    }
    my($conditions) = '';
    foreach my$key (sort keys(%{$ref})) {
        next if ($key =~ /^species$/);

        my($val) = $ref->{"$key"};
        next if ($val =~ /^\s*$/);

        $conditions .= ',' if ($conditions ne '');
        $conditions .= join('=', $key, $val);
    }

    #
    print <<EOB;
<tr><td><input type="button" name="btn_edit" value="Edit" onclick="mod_base_cluster($base_cluster_conf_id);"></td>
    <td align="center">$base_cluster_conf_id</td>
    <td>$ref->{'species'}</td>
    <td>$conditions</td>
EOB

    return;
}

###############################################################################
sub list_base_cluster {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};

    my($auth) = RECOG::RecogProject->new();

    #
    my($proj_ref) = $auth->get_project($user, $project_id);

    #
    my(@file_list);
    my($dir_base_cluster) = sprintf("%s/database.work/base_cluster/%d.d", $ENV{'RECOG_HOME'}, $project_id);
    my($dh) = IO::Dir->new("$dir_base_cluster");
    if ($dh) {
        while (my$file=$dh->read()) {
            next if ($file !~ /^\d+\.conf$/);

            push(@file_list, "$dir_base_cluster/$file");
        }
    }

    #
    my($sortfunc_ref) = sub {
        my($aid) = ($a =~ /(\d+)\.conf$/);
        my($bid) = ($b =~ /(\d+)\.conf$/);
        $aid <=> $bid;
    };
    @file_list = sort $sortfunc_ref @file_list;

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>List base cluster(s)</h1>\n";

    #
    if (!$proj_ref) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    print <<EOB;
<form name="frm_base_cluster" method="post" action="/htbin/recog_project/edit_base_cluster_conf_win.cgi" target="win_mod_base_cluster">
<input type="hidden" name="project_id" value="$project_id">
<input type="hidden" name="base_cluster_conf_id" value="">
<table border>
<tr><th></th>
    <th>ID</th>
    <th>Species</th>
    <th>Conditions</th>
</tr>

EOB

    #
    foreach my$file (@file_list) {
        my($base_cluster_conf_id) = ($file =~ /(\d+)\.conf$/);
        print_html_base_cluster($project_id, $base_cluster_conf_id, $file);
    }

    print <<EOB;
<tr><td><input type="button" name="btn_add_base_cluster" value="ADD" onclick="add_base_cluster();"></td>
</tr>
</table>
<input type="button" name="btn_close" value="Close" onclick="window.close();">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_id');
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    list_base_cluster($form_opt);
}

###############################################################################
1;#
###############################################################################
