#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;
require 'libMBGDaxes.pl';

###############################################################################
sub print_user {
    my($user_ref) = shift;

    print qq{<a href="/htbin/recog_project/view_user.cgi?user_id=$user_ref->{'id'}">$user_ref->{'name'}</a>\n};

    return;
}

###############################################################################
sub list_project_user_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};

    my($auth) = RECOG::RecogProject->new();

    #
    my($proj_ref) = $auth->get_project($user, $project_id);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Project member management</h1>\n";

    #
    if (!$proj_ref) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    print <<EOB;
<form name="frm_mng_project_user" method="post" action="">
<table border>
<tr><th>Name</th>
    <td>$proj_ref->{'PROP'}->{'name'}
        <input type="hidden" name="project_id" value="$project_id">
        <input type="hidden" name="user_name" value="">
    </td>
</tr>

EOB

    #
    print qq{<tr><th>Member(s)</th>\n};
    print "    <td>";
    print "        <table width=\"100%\" border>\n";
    my(@proj_user_list) = $auth->get_project_user_list($user, $project_id);
    my(%proj_user_hash);
    foreach my$user (@proj_user_list) {
            $proj_user_hash{"$user"} = 1;
            my($user_ref);
        print <<EOB;
<tr><td><input type="button" name="btn_del_project_user" value="Del" onclick="del_project_user(this.form, '$user');"></td>
    <td><input type="button" name="btn_mod_project_user" value="Mod" onclick="mod_project_user(this.form, '$user');"></td>
    <td>$user</td>
</tr>
EOB
    }

    my($html_user_list) = qq{<option value=""></option>\n};
    my(@user_list) = $auth->get_user_list($user);
    foreach my$user (@user_list) {
        next if (exists($proj_user_hash{"$user"}));

        $html_user_list .= qq{<option value="$user">$user</option>\n};
    }
    print <<EOB;
<tr><td style="text-align: center;" colspan="2"><input type="button" name="btn_add_user" value="Add" onclick="add_project_user(this.form);"></td>
    <td><select name="sel_user_name">
        $html_user_list
        </select>
    </td>
</tr>
EOB

    print "        </table>\n";
    print "    </td>";

    print <<EOB;
</table>
<input type="button" name="btn_close" value="Close" onclick="window.close();">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_id');
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    list_project_user_win($form_opt);
}

###############################################################################
1;#
###############################################################################
