#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub print_html {
    my($user_ref) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Change user password</h1>\n";

    #
    if (!$user_ref) {
        print "Sorry, found no user.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    print <<EOB;
<form name="frm_passwd" method="post" action="/htbin/recog_project/passwd.cgi">
<table border>
<tr><th>user</th>
    <td>$user_ref->{'name'}
        <input type="hidden" name="user_name" value="$user_ref->{'name'}">
    </td>
</tr>

<tr><th>new password</th>
    <td><input type="password" name="user_pass1" value="" size="50">
    </td>
</tr>

<tr><th>new password<br>(re-type)</th>
    <td><input type="password" name="user_pass2" value="" size="50">
    </td>
</tr>

</table>
<input type="button" name="btn_close" value="Close" onclick="window.close();">
<input type="submit" name="btn_passwd" value="Change password">
</form>

</body>
</html>
EOB

    return;
}

###############################################################################
#
sub print_text {
    my($user_ref) = shift;

    #
    print "Content-type: text/plain\n";
    print "\n";

    #
    if (!$user_ref) {
        return;
    }

    foreach my$key ('name', 'descr', 'organization') {

        my($val) = $user_ref->{"$key"};
        $val = RecogProjectCommon::percent_encoding($val);
        print $key, "\t", $val, "\n";
    }

    return;
}

###############################################################################
sub passwd_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($user_ref) = RecogProjectCommon::get_user_info($user);

    #
    if ($form_opt->{'mode'} =~ /^text$/i) {
        print_text($user_ref);
    }
    else {
        print_html($user_ref);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list);
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    passwd_win($form_opt);
}

###############################################################################
1;#
###############################################################################
