#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub put_cluster_set {
    my($form_opt) = shift;

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($user_name) = $ENV{'REMOTE_USER'};
    my($uid) = RecogProjectCommon::exists_user_name($db, $user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($tabid)    = $form_opt->{'tabid'};
    my($set_name) = $form_opt->{'set_name'};
    my($set_val)  = '';
    my($set_size) = 0;
    foreach my$line (split(/[\r\n]+/, $form_opt->{'set_val'})) {
        next if ($line =~ /^\s*$/);

        $set_val .= "$line\n";

        next if ($line =~ /^\s*id\s*$/i);
        $set_size++;
    }

    #
    my($cluster_set_ref) = RecogProjectCommon::get_cluster_set($db, $tabid, $set_name);
    my($mode) = $form_opt->{'mode'};
    if (!$mode) {
        if (!$cluster_set_ref) {
            RecogProjectCommon::insert_cluster_set($db, $uid, $tabid, $set_name, $set_val, $set_size);
        }
        else {
            # already exists ==> ERROR!
            my($sta) = 'error';
            my($msg) = 'already exists';
            RecogProjectCommon::print_status($sta, $msg);
            return;
        }
    }
    elsif ($mode =~ /^replace$/i) {
        if (!$cluster_set_ref) {
            RecogProjectCommon::insert_cluster_set($db, $uid, $tabid, $set_name, $set_val, $set_size);
        }
        else {
            RecogProjectCommon::update_cluster_set($db, $uid, $tabid, $set_name, $set_val, $set_size);
        }
    }

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('mode', 'tabid', 'set_name', 'set_val');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $val =~ s#^\s*##;
        $val =~ s#\s*$##;
        $form_opt->{"$key"} = $val;
    }

    put_cluster_set($form_opt);
}

###############################################################################
1;#
###############################################################################
