#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub put_gene_set {
    my($form_opt) = shift;

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($user_name) = $ENV{'REMOTE_USER'};
    my($uid) = RecogProjectCommon::exists_user_name($db, $user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($set_name) = $form_opt->{'set_name'};
    my($set_val)  = '';
    my($set_size) = 0;
    my(%spec_hash);
    foreach my$line (split(/[\r\n]+/, $form_opt->{'set_val'})) {
        next if ($line =~ /^\s*$/);

        $set_val .= "$line\n";

        next if ($line =~ /^\s*sp\s+/i);

        my($spec, $name) = split(/\s+/, $line);
        $spec_hash{"$spec"} = 1;

        $set_size++;
    }
    my(@spec_list) = sort(keys(%spec_hash));
    my($set_spec) = join(',', @spec_list);

    #
    my($gene_set_ref) = RecogProjectCommon::get_gene_set($db, $set_name);
    my($mode) = $form_opt->{'mode'};
    if (!$mode) {
        if (!$gene_set_ref) {
            RecogProjectCommon::insert_gene_set($db, $uid, $set_name, $set_val, $set_size, $set_spec);
        }
        else {
            # already exists ==> ERROR!
            my($sta) = 'error';
            my($msg) = 'already exists';
            RecogProjectCommon::print_status($sta, $msg);
            return;
        }
    }
    elsif ($mode =~ /^replace$/i) {
        if (!$gene_set_ref) {
            RecogProjectCommon::insert_gene_set($db, $uid, $set_name, $set_val, $set_size, $set_spec);
        }
        else {
            RecogProjectCommon::update_gene_set($db, $uid, $set_name, $set_val, $set_size, $set_spec);
        }
    }

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('mode', 'set_name', 'set_val');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $val =~ s#^\s*##;
        $val =~ s#\s*$##;
        $form_opt->{"$key"} = $val;
    }

    put_gene_set($form_opt);
}

###############################################################################
1;#
###############################################################################
