#!/usr/bin/perl -s
use strict;
use CGI;
use File::Path;
use IO::Dir;
use IO::File;
use RecogProjectCommon;
$main::DEBUG = 1;

###############################################################################
#
sub select_base_cluster {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};
    my($auth) = RECOG::RecogProject->new();

    #
    my($sta_sys_proj) = $auth->is_system_project($user, $project_id);
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if ($sta_sys_proj) {
        if (!$sta_sysadm) {
            $auth->print_html_sorry($user);
            exit();
        }
    }

    #
    my($proj_ref) = $auth->load_project($user, $project_id);
    my($dir_proj_bc) = "$ENV{'RECOG_HOME'}/etc/projects/$project_id.d/base_cluster";
    File::Path::mkpath("$dir_proj_bc", 0, 0750) if (! -e "$dir_proj_bc");

    #
    my(%base_cluster_id_old_hash);
    my($dh) = IO::Dir->new("$dir_proj_bc");
    if ($dh) {
        while (my$file=$dh->read()) {
            next if ($file =~ /^\./);
            next if (($file !~ /^\d+\_\d+$/) && ($file !~ /^\d+$/) && ($file !~ /^default$/));

            unlink("$dir_proj_bc/$file");
        }
    }

    #
    my($base_cluster_tab_id) = $form_opt->{'base_cluster_tab_id'};
    my($file_base_cluster) = "$dir_proj_bc/$base_cluster_tab_id";
    my($fh) = IO::File->new("$file_base_cluster", 'w');
    if ($fh) {
        my(@spid_list);
	my($file_spidtab);
	if ($form_opt->{'base_cluster_server'} eq  $main::URL_PUBLIC_SERVER) {
	    $file_spidtab = "$ENV{'RECOG_HOME'}/etc/spid.tab.dist";
	} else {
	    $file_spidtab = "$ENV{'RECOG_HOME'}/etc/spid.tab";
	}
	print STDERR "$file_spidtab\n";
        my(@spec_list) = split(/,/, $form_opt->{'base_cluster_species'});
        foreach my$spec (@spec_list) {
            my($spid) = sp2spid($spec, $file_spidtab);
            #next if (!$spid);
	    print STDERR "$spid\n" if (!$spid);
            push(@spid_list, $spid);
        }
        $fh->print(join("\t", 'spid',   "@spid_list"), "\n");
        $fh->print(join("\t", 'server', $form_opt->{'base_cluster_server'}), "\n");
        $fh->close();
    }

    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print <<EOS;
<script>
//this.top.opener.location.reload();
</script>
EOS
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Select base cluster</h1>\n";

    print <<EOB;
Done.<br />

<form>
<input type="button" name="btn_close" value="Close" onclick="window.close();">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my(@key_list) = ('project_id',
                     'base_cluster_tab_id',
                     'base_cluster_species',
                     'base_cluster_server',
                    );
    my($form_opt) = {};
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    select_base_cluster($form_opt);
}
###############################################################################
1;#
###############################################################################
