///////////////////////////////////////////////////////////////////////////////
//
//DIR_proj = 'MyMBGD';
DIR_proj = 'recog_build';

///////////////////////////////////////////////////////////////////////////////
//
function searchTaxonomyId(spName, abbreName) {
    var name;

    if (spName.value != '') {
        name = spName.value;
    }
    else if (abbreName.value != '') {
        name = abbreName.value;
    }
    else {
        alert("Please input 'Species Name' or 'Abbreviation Name'");
        return;
    }

    name = name.replace(/^\s+/, '');
    name = name.replace(/\s+$/, '');
    if (name == '') {
        alert('Please input Genome Name.');
        doc.user_genome.genome_name.focus();
        return;
    }

//    var url = 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?DB=Taxonomy&CMD=search&term=' + escape(name);
    var url = '/htbin/searchTaxonomyDB?species=' + escape(name);
    open(url, 'search_taxonomy_id');

    return;
}

///////////////////////////////////////////////////////////////////////////////
// save form values
var SAVE_formOptions;
function saveFormData(doc) {
    var i, j;

    SAVE_formOptions = new Object();
    for(i = 0; i < doc.forms.length; i++) {
        var form = doc.forms[i];
        SAVE_formOptions[i] = new Object();

        for(j = 0; j < form.elements.length; j++) {
            var elm = form.elements[j];

            if (elm.type == 'checkbox') {
                SAVE_formOptions[i][j] = elm.checked;
            }
            else if (elm.type == 'hidden') {
                SAVE_formOptions[i][j] = elm.value;
            }
            else if (elm.type == 'password') {
                SAVE_formOptions[i][j] = elm.value;
            }
            else if (elm.type == 'radio') {
                SAVE_formOptions[i][j] = elm.checked;
            }
            else if (elm.type == 'select-one') {
                SAVE_formOptions[i][j] = elm.selectedIndex;
            }
            else if (elm.type == 'text') {
                SAVE_formOptions[i][j] = elm.value;
            }
            else if (elm.type == 'textarea') {
                SAVE_formOptions[i][j] = elm.value;
            }
            else if (elm.type == 'file') {
                SAVE_formOptions[i][j] = elm.value;
            }
            else {
                // no save
            }
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
//
function isChangedFormData(doc) {
    var i, j;

    for(i = 0; i < doc.forms.length; i++) {
        var form = doc.forms[i];

        for(j = 0; j < form.elements.length; j++) {
            var elm = form.elements[j];

            if (elm.type == 'checkbox') {
                if (SAVE_formOptions[i][j] != elm.checked) {
                    return true;
                }
            }
            else if (elm.type == 'hidden') {
                if (SAVE_formOptions[i][j] != elm.value) {
                    return true;
                }
            }
            else if (elm.type == 'password') {
                if (SAVE_formOptions[i][j] != elm.value) {
                    return true;
                }
            }
            else if (elm.type == 'radio') {
                if (SAVE_formOptions[i][j] != elm.checked) {
                    return true;
                }
            }
            else if (elm.type == 'select-one') {
                if (SAVE_formOptions[i][j] != elm.selectedIndex) {
                    return true;
                }
            }
            else if (elm.type == 'text') {
                if (SAVE_formOptions[i][j] != elm.value) {
                    return true;
                }
            }
            else if (elm.type == 'textarea') {
                if (SAVE_formOptions[i][j] != elm.value) {
                    return true;
                }
            }
            else if (elm.type == 'file') {
                if (SAVE_formOptions[i][j] != elm.value) {
                    return true;
                }
            }
        }
    }

    return false;  // no change
}

///////////////////////////////////////////////////////////////////////////////
//
function changeUserGenome(doc, ugid) {
    var sta;

    sta = isChangedFormData(doc);
    if (sta) {
        sta = confirm('These changes will be lost. Are you sure?');
        if (! sta) {
            return;
        }
    }

    //
    doc.formChangeUserGenome.user_genome_id.value = ugid;
    doc.formChangeUserGenome.submit();
}

///////////////////////////////////////////////////////////////////////////////
//
function addNewUserGenome(doc) {
    var sta;

    sta = isChangedFormData(doc);
    if (sta) {
        sta = confirm('These changes will be lost. Are you sure?');
        if (! sta) {
            return;
        }
    }

    //
    doc.formAddNewUserGenome.submit();
}

///////////////////////////////////////////////////////////////////////////////
//
function applyUserGenome(doc) {
    //
    doc.formApplyUserGenome.submit();
}

///////////////////////////////////////////////////////////////////////////////
//
function removeThisGenome(doc, idUserGenome) {
    sta = confirm('');
    if (! sta) {
        return;
    }

    //
    doc.formRemoveUserGenome.user_genome_id.value = idUserGenome;
    doc.formRemoveUserGenome.submit();
}

///////////////////////////////////////////////////////////////////////////////
//
function removeThisChromosome(doc, idUserGenome, idUserChromosome) {
    var sta;

    sta = isChangedFormData(doc);
    if (sta) {
        sta = confirm('These changes will be lost. Are you sure?');
        if (! sta) {
            return;
        }
    }

}

///////////////////////////////////////////////////////////////////////////////
//
function setShortName(src, dst) {
    var srcName = src.value;

    var idxFirstSpace = srcName.indexOf(" ");
    if (0 <= idxFirstSpace) {
        dst.value = srcName.charAt(0).toUpperCase() + ".";

        var valSecond = srcName.substr(idxFirstSpace + 1).toLowerCase();
        var idxSecondSpace = valSecond.indexOf(" ");
        if (0 <= idxSecondSpace) {
            dst.value += valSecond.substr(0, idxSecondSpace);
        }
        else {
            dst.value += valSecond;
        }
    }
    else {
        dst.value = src.value;
    }
}

///////////////////////////////////////////////////////////////////////////////
//
function trim(elm) {
    var val = elm.value;

    val = val.replace(/^\s+/,"");
    val = val.replace(/\s+$/,"");

    elm.value = val;
}

///////////////////////////////////////////////////////////////////////////////
//
function updateUserGenomeList() {
    var win;

    win = open('', 'list_user_genome');
    win.location = '/htbin/' + DIR_proj + '/viewUserGenomeListWin.cgi';
}

///////////////////////////////////////////////////////////////////////////////
//
function updateUserGenome(gid) {
    this.location = '/htbin/' + DIR_proj + '/modUserGenomeWin.cgi?id_user_genome=' + gid;
}

///////////////////////////////////////////////////////////////////////////////
//
function updateUserChromosomeList(gid) {
    var win;

    win = open('', 'list_user_chromosome');
    win.location = '/htbin/' + DIR_proj + '/viewUserChromosomeListWin.cgi?id_user_genome=' + gid;
}

///////////////////////////////////////////////////////////////////////////////
//
function updateUserChromosome(gid, cid) {
    this.location = '/htbin/' + DIR_proj + '/modUserChromosomeWin.cgi?id_user_genome=' + gid + '&id_user_chromosome=' + cid;
}

///////////////////////////////////////////////////////////////////////////////
//
function clearUserChromosome() {
    var win;

    win = open('', 'list_user_chromosome');
    win.location = '/' + DIR_proj + '/blank.html';

    win = open('', 'mod_user_chromosome');
    win.location = '/' + DIR_proj + '/blank.html';
}

///////////////////////////////////////////////////////////////////////////////
//
function loadUserChromosome(gid, cid) {
    var win;

    //
    win = open('', 'list_user_chromosome');
    win.location = '/htbin/' + DIR_proj + '/viewUserChromosomeListWin.cgi?id_user_genome=' + gid;

    //
    win = open('', 'mod_user_chromosome');
    win.location = '/htbin/' + DIR_proj + '/modUserChromosomeWin.cgi?id_user_genome=' + gid + '&id_user_chromosome=' + cid;

    return;
}

