#!/usr/bin/perl -s

$Delim = "#";

$Dir{'Plus'} = '+';
$Dir{'Minus'} = '-';

$EVAL_THRE = 0.05 if (! $EVAL_THRE);
#$TOP = 5 if (! $TOP);

$out = 'all' if (! $out);

while (<>) {
	chop;
	if (/^[ ]*Query=[ ]*([^ ]*)/) {
		$query = $1;
		if ($qdb && $query !~ /:/) {
			$query = "$qdb:$query";
		} elsif ($qdb && $query =~ /gp:(.*)/) {
			$query = "$qdb:$1";
		}
		$qfrom = $qto = $sfrom = $sto = '';
		$rank = 0;
		if ($out eq 'all') {
			print "Query=$query\n";
		}
	} elsif (/[ ]*\(([0-9]+) letters\)/) {
		$qlen = $1;
	} elsif (/Sequences producing significant alignments/) {
		$status = 'rank';
		$dmy = <>;
	} elsif ($status eq 'rank') {
		if (/^$/) {
			$status = 'hsp';
			$entname = '';
		} else {
			$enttit = substr($_, 0, 66);
			$enttit =~ s/^ *//;
			($entname, $title) = split(/[ \t]+/, $enttit);
			if ($sdb && $entname !~ /:/) {
				$entname = "$sdb:$entname";
			} elsif ($sdb && $entname =~ /gp:(.*)/) {
				$entname = "$sdb:$1";
			}
			$score_data = substr($_, 67);
			$score_data =~ s/^[ ]+//;
			($hiscore, $evalue, $n) = split(/\s+/, $score_data);
#			$rank{$entname} =  join($Delim,$hiscore,$evalue,$n);
			$evalue{$entname} = $evalue;
			$hiscore{$entname} = $hiscore;
		}
	} elsif ($status eq 'hsp') {
		if (/^>[ ]*([^ ]+)/) {
			if ($qfrom) {
				&add_hspdata;
				print $hspdata;
				$hspdata = '';
			}
			$entname = $1;
			if (/^>[ ]*([^ ]+) +(.*)$/) {
				$descr = $2;
			}
			$descr_flag = 1;
			if ($sdb && $entname !~ /:/) {
				$entname = "$sdb:$entname";
			} elsif ($sdb && $entname =~ /gp:(.*)/) {
				$entname = "$sdb:$1";
			}
		} elsif (/^[ ]*Length = ([0-9]+)/) {
			$len = $1;
			$rank++;
			$descr = substr($descr, 0, 120);
			&out_rankdata;
			$hspnum = 0;
			$descr_flag = 0;
#			$descr = '';
			$qfrom = $qto = $sfrom = $sto = '';

		} elsif (/^[ ]*Score[ ]*=[ ]*([0-9\.]+)[ ]*bits[ ]*\(([0-9\.]+)\),[ ]*Expect[\(\)0-9]*[ ]*=[ ]*([0-9\.\-e]+)/) {
			if ($qfrom) {
				&add_hspdata;
				$qfrom = $qto = $sfrom = $sto = '';
			}
			$score = $1;
			$bit = $2;
			$expect = $3;
			$pval = 0;  # blast2 ϡP-value ̵ʤä
			$hspnum++;
		} elsif (/^[ ]*Identities[ ]*=[ ]*([0-9]+)\/([0-9]+)[ ]*\(([0-9]+)\%\)/) {
			$ident = $1;
			$hsplen = $2;
			$percentident = $3;
		    ## old version
			if (/Positives[ ]*=[ ]*([0-9]+)\/([0-9]+)[ ]*\(([0-9]+)%\)/) {
				$positive = $1;
				$hsplen2 = $2;
				$percentpositive = $3;
			}
			if (/Strand = ([A-Za-z]+) *\/ *([A-Za-z]+)/) {
				$str1 = $Dir{$1}; $str2 = $Dir{$2};
			}
		} elsif (/Strand = ([A-Za-z]+) *\/ *([A-Za-z]+)/) {
		    ## new version
			$str1 = $Dir{$1}; $str2 = $Dir{$2};
		} elsif (/Frame = ([\+\-][1-3]+)/) {
			$frame = $1;
		} elsif (/^Query:[ ]*([0-9]+)[ ]*[A-Za-z\-\*]+[ ]*([0-9]+)/) {
			$qfrom = $1 if (! $qfrom);
			$qto = $2;
		} elsif (/^Sbjct:[ ]*([0-9]+)[ ]*[A-Za-z\-\*]+[ ]*([0-9]+)/) {
			$sfrom = $1 if (! $sfrom);
			$sto = $2;
		} elsif (/^Matrix:/) {
			if ($qfrom) {
				&add_hspdata;
				print $hspdata;
				$hspdata = '';
			}
			if ($out eq 'all') {
				print "//\n";
			}
		} elsif ($descr_flag) {
			s/^ +//;
			$descr .= " $_";
		}
	}
}

sub  out_rankdata {
	return if ($evalue{$entname} > $EVAL_THRE);
	if ($out eq 'tab') {
		return if ($TOP && $rank > $TOP);
		print join("\t", $query,$qlen,$entname,$len,
		    $hiscore{$entname},$evalue{$entname},$descr) . "\n";
	} elsif ($out eq 'all') {
		print "RANK $rank$Delim";
		print join($Delim,$query,$qlen,$entname,$len,
		    $hiscore{$entname},$evalue{$entname},$descr) . "\n";
	}
}
sub  add_hspdata {
	return if ($evalue{$entname} > $EVAL_THRE);
	if ($qfrom > $qto) {
		$str1 = '-';
		$tmp = $qfrom; $qfrom = $qto; $qto = $tmp;
	} else {
		$str1 = '+';
	}
	if ($sfrom > $sto) {
		$str2 = '-';
		$tmp = $sfrom; $sfrom = $sto; $sto = $tmp;
	} else{
		$str2 = '+';
	}
	if ($out eq 'tab') {
		return if (! $hsptab);
		return if ($TOP && $rank > $TOP);
		print join("\t", $hspnum, $qfrom, $qto, $sfrom, $sto,
		$score, $bit, $expect, $pval,
		$ident,$hsplen,$percentident,
		$positive,$hsplen2,$percentpositive,$str1,$str2) . "\n";
	} elsif ($out eq 'hsptab') {
		return if ($TOP && $rank > $TOP);
		print join("\t", $query, $qlen, $entname, $len,
		$evalue{$entname},
		$hspnum, $qfrom, $qto, $sfrom, $sto, $score, $expect,
		$descr) . "\n";
	} elsif ($out eq 'all') {
	    $hspdata .= join($Delim,
		"HSP $hspnum", "$qfrom-$qto","$sfrom-$sto",
		$score, $bit, $expect, $pval,
		$ident,$hsplen,$percentident,
		$positive,$hsplen2,$percentpositive,$str1,$str2,$frame
	    ) . "\n";
	}
}

