#!/usr/bin/perl -s

###############################################################################
# ǡ١ϿƤǡΤchromosome/gene ơ֥
# ϢդƤʤǡ
#   оݥơ֥
#     dnaseq
#     geneseq
#     proteinseq
#
###############################################################################
use MBGD;
require "MBGD_Conf.pl";

# ٤˺쥳ɿ
$NUM_delrec = 100;

###############################################################################
# chromosome ơ֥˴ϢդƤʤ dnaseq ơ֥Υǡ
sub cleanupDnaSeq {
    my($dbname) = @_;
    my($tabSeq)     = "dnaseq";
    my($tabRef)     = "chromosome";
    my($tabRefColm) = "seq";

    &cleanupSeq($dbname, $tabSeq, $tabRef, $tabRefColm);
}

###############################################################################
# gene ơ֥˴ϢդƤʤ geneseq ơ֥Υǡ
sub cleanupGeneSeq {
    my($dbname) = @_;
    my($tabSeq)     = "geneseq";
    my($tabRef)     = "gene";
    my($tabRefColm) = "ntseq";

    &cleanupSeq($dbname, $tabSeq, $tabRef, $tabRefColm);
}

###############################################################################
# gene ơ֥˴ϢդƤʤ proteinseq ơ֥Υǡ
sub cleanupProteinSeq {
    my($dbname) = @_;
    my($tabSeq)     = "proteinseq";
    my($tabRef)     = "gene";
    my($tabRefColm) = "aaseq";

    &cleanupSeq($dbname, $tabSeq, $tabRef, $tabRefColm);
}

###############################################################################
# gene ơ֥˴ϢդƤʤ proteinseq ơ֥Υǡ
sub cleanupSeq {
    my($dbname, $tabSeq, $tabRef, $tabRefColm) = @_;
    my($db);
    my($tab);
    my($opt);

    # DB ³
    $db = MBGD::DB->new($dbname);

    # оݤ sequence 쥳ɤ
    $tab = "$tabSeq seq left join $tabRef on seq.id=$tabRef.$tabRefColm";
    $opt->{'columns'} = "seq.id id";
    $opt->{'where'} = "$tabRef.id is null";
    $res = $db->select_fetch($tab, $opt);

    while(scalar(@{$res->{'INFO'}})) {
        my($sql);
        my($sth);
        my(@delrec) = splice(@{$res->{'INFO'}}, 0, $NUM_delrec);

        my($whereCond) = '';
        foreach $ent (@delrec) {
            $whereCond .= "," if ($whereCond ne '');
            $whereCond .= $ent->{'id'};
        }

        $sql = "delete from $tabSeq where id in ($whereCond)";
        print STDERR "SQL : $sql\n" if ($main::DEBUG);
        $sth = $db->execute("$sql");
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dbname);

    if (scalar(@ARGV) < 1) {
        print STDERR "Usage : $0 dbname\n";
        exit;
    }

    $dbname = "dbi:mysql:$ARGV[0]";

    &cleanupDnaSeq($dbname);
    &cleanupGeneSeq($dbname);
    &cleanupProteinSeq($dbname);
}

###############################################################################
1;#
###############################################################################
