#!/usr/bin/perl -s
use strict;
use MBGD;


###############################################################################
#
sub createDatabase {
    my($dbname) = shift;

    my($dbOpt) = {};
	$dbOpt->{'new'} = 1;

    my($db) = new MBGD::DB('mysql', $dbOpt);

    my($sql) = "drop database if exists $dbname;";
    $db->do($sql);

    my($sql) = "create database if not exists $dbname;";
    $db->do($sql);

    #
    $db->disconnect();
}

###############################################################################
#
sub createTables {
    my($dbname) = shift;
    my(@tabList) = ('Genome',
                    'DNASeq',
                    'GeneSeq',
                    'ProteinSeq',
                    'Chromosome',
                    'Gene',
                    'Homology',
                    'Motif',
                    'ProtMotif');

    my($dbOpt) = {};
    my($db) = new MBGD::DB($dbname, $dbOpt);
    if ($db->{'conn'} =~ /^\s*$/) {
        die("Can not connect DB[$dbname]");
    }

    foreach my$tabName (@tabList) {
        my($opt) = {};
        $opt->{'tablename'} = lc($tabName);
        my($tab) = new MBGD::DBTable($db,
                                     $tabName,
                                     $opt);

        # create_table() $B%a%=%C%I$r;H$&$H(B $MBGD_HOME/schema $B0J2<(B
        # $dbname, user, base $B$N=g$K(B Schema $B$,8!:w$5$l$k(B
        $tab->create_table();
    }
    $db->disconnect();
}

###############################################################################
if ($0 eq __FILE__) {

    my($dbname) = shift(@ARGV);
    if (! $dbname) {
        $dbname = 'mbgd';
    }
    createDatabase($dbname);
    createTables($dbname) if (! $main::NO_TABLES);
}

###############################################################################
1;#
###############################################################################
