#!/usr/bin/perl -s
use strict;
use FilePath;
require "InfoSpec.pl";

sub printUsage {
    print "Usage :: $0 -spid=SPID -spec=SPEC -nc=N_chromosome -np=N_plasmid\n";
}

sub createSpidTempl {
    my($spid) = shift;
    my($spec) = shift;
    my($nc) = shift;
    my($np) = shift;

    my($dir) = "$ENV{'MBGD_HOME'}/species/$spid";
    mkpath("$dir/GB", 0, 0750);
    mkpath("$dir/GM/data", 0, 0750);

    #
    my($filename) = "$dir/GM/genome.txt";
    my($ref) = {};
    $ref->{'spid'} = $spid;
    $ref->{'sp'} = $spec;
    $ref->{'orgname'} = '';
    $ref->{'abbrev'} = '';
    $ref->{'strain'} = '';
    $ref->{'taxid'} = '';
    $ref->{'family'} = '';
    $ref->{'genus'} = '';
    $ref->{'species'} = '';
    $ref->{'source'} = 'refseq';
    $ref->{'institution'} = '';
    $ref->{'wwwlink'} = 'http://mbgd.genome.ad.jp/';
    $ref->{'medid'} = '';
    $ref->{'journal'} = '';
    $ref->{'date_release'} = '2099-12-31';
    $ref->{'date_modify'} = '2099-12-31';
    writeGenomeTxt($filename, $ref);

    #
    $n = 1;
    formy$i = 0; $i < ($nc + $np); $i++) {
        my($filename) = "$dir/GM/data/$n.chromosome.txt";
        my($type, $nn);
        if ($i < $nc) {
            $type = 'chromosome';
            $nn = $n;
        } else {
            $type = 'plasmid';
            $nn = $n - $nc;
        }

        my($ref) = {};
        $ref->{'spid'} = $spid;
        $ref->{'seqno'} = $n;
        $ref->{'name'} = "$type$nn";
        $ref->{'type'} = "$type";
        $ref->{'shape'} = 'circular/linear';
        $ref->{'accession'} = '';
        $ref->{'gi'} = '';
        writeGenomeTxt($filename, $ref);

        foreach my$f ('gene', 'chrseq', 'geneseq', 'protseq') {
            $filename = "$dir/GM/data/$n.$f";
            new FileHandle(">$filename");
        }

        $n++;
    }

    return;
}

if ($0 eq __FILE__) {
    if (!$ENV{'MBGD_HOME'}) {
        print "Please set \$MBGD_HOME\n";
        exit(0);
    }

    if (!$main::spid || !$main::spec) {
        printUsage();
        exit(0);
    }
    $main::nc = 1 if (! $main::nc);
    $main::np = 0 if (! $main::np);

    createSpidTempl($main::spid, $main::spec, $main::nc, $main::np);
}
1;#
