#!/usr/bin/perl -s
use strict;
use File::Path;
use FileHandle;
use RECOG::RecogCommon;
use RecogBuild;
require "InfoSpec.pl";


###############################################################################
#
sub createUgSkeleton {
    my($spid) = shift;
    my($sp) = shift;
    my($nchr) = shift;
    my($filename);
    my($fh);

    #
    if (! $spid) {
        $spid = RecogBuild::get_new_spid();
        if (! $spid) {
            print STDERR "WARNING :: Too many user genome data.\n";
            exit(0);
        }
    }
    my($dir)   = "$ENV{'MBGD_HOME'}/species/$spid";
    my($dirSp) = "$ENV{'MBGD_HOME'}/species/$sp";

    # update spidtab
    my($fileSpidTab) = $main::FILE_spidtab;
    my($info) = getInfoSpecTab($fileSpidTab);
    if (exists($info->{'SPID2DIR'}->{"$spid"})) {
        # бǡǥ쥯ȥ¸ߤʤ
        # spid 񤭤
    }
    if (exists($info->{'NAME2DIR'}->{"$sp"})) {
        print STDERR "ERROR :: This sp is used.[$sp]\n";
        exit(-1);
    }
    addInfoSpecTabEntry($info, $spid, $sp, $dir);
    setInfoSpecTab($fileSpidTab, $info);

    #
    mkpath("$dir/gm/data", 0, 0750);
    mkpath("$dir/GB",      0, 0750);
    symlink($dir, $dirSp);
    print STDERR "Create skelton for $spid\n";
    print STDERR "($dir)\n";

    # genome
    $filename = "$dir/gm/genome.txt";
    $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
    $fh->print('sp',           "\t", $sp, "\n");
    $fh->print('abbrev',       "\t", 'Y.orgname', "\n");
    $fh->print('orgname',      "\t", 'Your orgname', "\n");
    $fh->print('strain',       "\t", '', "\n");
    $fh->print('taxid',        "\t", '', "\n");
    $fh->print('date_release', "\t", 'YYYY-MM-DD', "\n");
    $fh->print('specweight',   "\t", '', "\n");
    $fh->close();

    # chromosome
    for(my$i = 1; $i <= $nchr; $i++) {
        #
        $filename = "$dir/gm/data/$i.chromosome.txt";
        $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
        $fh->print('name',   "\t", '', "\n");
        $fh->print('shape',  "\t", 'circular/linear', "\n");
        $fh->print('type',   "\t", 'chromosome/plasmid', "\n");
        $fh->print('length', "\t", '', "\n");
        $fh->close();

        #
        $filename = "$dir/gm/data/$i.gene";
        $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
        $fh->close();

        #
        $filename = "$dir/gm/data/$i.protseq";
        $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
        $fh->close();

        #
        $filename = "$dir/gm/data/$i.chrseq";
        $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
        $fh->close();
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    if ($main::spid) {
        if ($main::spid !~ /^gu\d{5}$/) {
            print STDERR "ERROR :: Wrong spid=$main::spid.\n";
            exit(0);
        }
        elsif (-e "$ENV{'MBGD_HOME'}/species/$main::spid") {
            # spid Ʊ̾Υǥ쥯ȥ꤬뤿ᡢ
            print STDERR "WARNING :: Already exists spid=$main::spid.\n";
            exit(0);
        }
    }
    if (! $main::sp || ! $main::nchr) {
        print STDERR "Usage :: $0 [-spid=gu99999] -sp=abc -nchr=N\n";
        exit(0);
    }

    createUgSkeleton($main::spid, $main::sp, $main::nchr);
}

1;#

