#!/usr/bin/perl -s

use MBGD;
require 'MBGD_common.pl';
require 'commonLib.pl';

if (! $main::DIR) {
    $main::DIR = $main::DIR_ftp_goa;
}

$tmpfile = "/tmp/tmp_insertGO.$$";
$filterGOA = "$ENV{'MBGD_HOME'}/build/filterGOA.pl";

$go_table = "goa";
$go_schema = "(db char(10) not null,
		dbobj_acc char(8) not null,
		dbobj_id char(15) not null,
		qualifier char(15) not null,
		go_id varchar(12) not null,
		db_ref varchar(20),
		evidence char(10),
		evi_with char(20),
		go_aspect char(10),
		dbobj_name char(15),
		synonym char(15),
		dbobj_type char(15),
		taxid char(15),
		date date,
		assignedby char(20),
		PRIMARY KEY (db,dbobj_acc,go_id,db_ref),
		KEY (go_id),
		KEY (db,dbobj_id),
		KEY (taxid)
	)";

    #
	system("$main::CMD_mysqladmin create uniprot > /dev/null 2>&1");

$db = MBGD::DB->new("dbi:mysql:uniprot");
&create_table($db, $go_table, $go_schema);

foreach $f (<$main::DIR/*.goa>) {
	print "$f\n";
	if ($filterGOA) {
		system("$filterGOA $f > $tmpfile");
		$go_file = $tmpfile;
	} else {
		$go_file = $f;
	}
	&load_table($db, $go_file, $go_table);
	if ($filterGOA) {
		unlink($tmpfile);
	}
}
$db->disconnect;

