#!/usr/bin/perl -s

use MBGD;
require 'commonLib.pl';
require "MBGD_common.pl";

$gene2acc_file = "$main::DIR/gene2accession";
$gene2acc_table = "gene2acc";
$gene2acc_schema = "(
		taxid int not null,
		geneid int not null,
		status char(24),
		RNA_acc char(14),
		RNA_gi int,
		prot_acc char(14),
		prot_gi int,
		genome_acc char(14),
		genome_gi int,
		from1 int,
		to1 int,
		dir char(1),
		assembly char(24),
		KEY (geneid),
		KEY (prot_acc),
		KEY (prot_gi) )";

    #
	system("$main::CMD_mysqladmin create ncbi_gene");

$db = MBGD::DB->new("dbi:mysql:ncbi_gene");

&load_data_into_new_table($db, $gene2acc_file,
		$gene2acc_table, $gene2acc_schema);
#&create_table($db, $gene2acc_table, $gene2acc_schema);
#&load_table($db, $gene2acc_file, $gene2acc_table);

$db->disconnect;

sub insert_table {
	my($infile, $table, $schema) = @_;
	if ($db->exist_table("$table")) {
		$db->drop_tables("$table");
	}
	$db->execute("drop table if exists $table");
	$db->execute("create table $table $schema");
	$db->execute("load data local infile '$infile' into table $table");
	$db->flush_table("$table");
}
