#!/usr/bin/perl -s

###############################################################################
# ʪ̾ܥǥ쥯ȥ̾򵭽ҤƤեȤ
# GenBank ǡեΥԡ
# ԡоݤϡ*.gbk  *.faa
#
# Usage : $0  [base-dir]
#     base-dir      : GenBank ΥǡեǼǥ쥯ȥ
#                     .../genbank/genomes/Bacteria 
#
# Ȥ
#   % $0 [/db/bio/ftp/ncbi-ftp/genbank/genomes/Bacteria]
#
#
###############################################################################
require "MBGD_Conf.pl";
require "CheckGbkFile.pl";
require "InfoSpec.pl";
require "MBGD_common.pl";
require "MBGD_commonUpdate.pl";
use POSIX;

$main::RECCOUNT = 3; # ؤΥǥ쥯ȥõ뤫
###############################################################################
# MBGD Υǡǥ쥯ȥ GenBank ǡե򥳥ԡ
sub CopyGbk {
    my($spid, $dirSrc) = @_;
    my($dirSpid);
    my($dirDst);
    my($file);
    my($fileSrc);
    my($fileDst);
    my($gbkDef);
    my($cmd);
    my($chgnum);
    local(*DH);

    # ԡǥ쥯ȥ
    $dirSpid = "$DIR_species/$spid";
    if (! -e "$dirSpid") {
        mkdir("$dirSpid", 0750);
    }
    $dirDst = "$dirSpid/GB";
    if (! -e "$dirDst") {
        mkdir("$dirDst", 0750);
    }
    # Copy Υǥ쥯ȥˤ *.gbk ե
    my($dstFiles) = {};
    my($dh) = new DirHandle("$dirDst") || die("Can not open $dirDst($!)");
    foreach $file (sort($dh->read())) {
        next if ($file =~ /^\./);
        next if ($file !~ /\.gbk/);

        my($name) = ($file =~ /^(.+)\.gbk/);
        $dstFiles->{"$name"} = $file;
    }

    my ($gbkFlag) = 0;
    opendir(DH, "$dirSrc") || die("Can not open $dirSrc($!)");
    foreach $file (readdir(DH)) {
        next if ($file =~ /^\./);
        next if ($file !~ /\.gbk/);

        # ԡоݤΥե.gbk
        my($name) = ($file =~ /^(.+)\.gbk/);
        delete($dstFiles->{"$name"});
        $fileSrc = "$dirSrc/$file";
        $fileDst = "$dirDst/$file";
	$fileDstExist = &checkCompressed($fileDst,$fileSrc);

        if (! -e "$fileSrc") {
            # ʤԡΥե뤬ʤ
            print STDERR "WARNING :: File not found.($fileSrc)\n";
            next;
        }

	$gbkFlag=1;

        if (-e "$dirDst/ignore/$file") {
#            print STDERR "compare $fileSrc $dirDst/ignore/$file\n";
            system("$CMD_cmp -s $fileSrc $dirDst/ignore/$file");
#            if (($? >> 8) == 0) {
#            if ( WIFEXITED($?) ) {
            if ( WIFEXITED($?) && (WEXITSTATUS($?) == 0) ) {
		print STDERR "Skip -- ignore/$file\n";
		next;
	    }
	}

        if ($fileDstExist) {
            print STDERR "compare $fileSrc $fileDstExist\n" if ($main::DEBUG);
            $cmd = "$CMD_cmp -s $fileSrc $fileDstExist";
            system("$cmd");
#            if (($? >> 8) == 0) {
#            if ( WIFEXITED($?) ) {
            if ( WIFEXITED($?) && (WEXITSTATUS($?) == 0) ) {
		# no change
                print STDERR "no change\n" if ($main::DEBUG);
                next;
            }
        # եΥХååפ
            &BackupFile($fileDstExist, "$dirDst/old");
        }

        $chgnum++;

        # .gbk 򥳥ԡ
        print STDERR "copy $fileDst\n";
        $cmd = "$CMD_cp -p $fileSrc $fileDst";
        system("$cmd");

        # .faa 
	$fileSrcGbk = $fileSrc; $fileDstGbk = $fileDst;
	foreach $suff ('faa', 'ptt', 'rnt', 'rpt', 'gff') {
		$fileSrc = $fileSrcGbk; $fileDst = $fileDstGbk;
		$fileSrc =~ s#.gbk#.$suff#; $fileDst =~ s#.gbk#.$suff#;
		$fileDstExist = &checkCompressed($fileDst,$fileSrc);
       		&BackupFile($fileDstExist, "$dirDst/old");
       		$cmd = "$CMD_cp -p $fileSrc $fileDst";
       		system("$cmd");
	}
    }
    closedir(DH);

    if($gbkFlag < 1) { #GenBankե뤬ĤǤƤʤ
        # ԡǥ쥯ȥ
        $dirSpid = "$DIR_species/$spid";
        if (! -e "$dirSpid") {
            mkdir("$dirSpid", 0750);
        }
        $dirDst = "$dirSpid/GB";
        if (! -e "$dirDst") {
            mkdir("$dirDst", 0750);
        }
	$chgnum = &searchSubDir($dirDst, $dirSrc, $main::RECCOUNT, $dstFiles);
        if($chgnum==0) {
            print STDERR "$spid : GenBank file invalid.\n";
        }
    }

    # ե̾ѹ¸ߤʤʤäե old ˰ư
    foreach $key (keys(%{$dstFiles})) {
        my($file) = $dstFiles->{"$key"};
        &BackupFile("$dirDst/$file", "$dirDst/old");
    }

    return $chgnum;
}

###############################################################################
# եΥХååפ
sub BackupFile {
    my($fileSrc, $dirname) = @_;
    my($filename);
    my(@fileList);
    my($mtime);
    my($sec, $min, $hour, $day, $mon, $year);

    if (! -e "$fileSrc") {
        # ХååоݤΥե뤬ʤ
        return;
    }

    # Хååץǥ쥯ȥκ
    mkdir("$dirname", 0750);

    # Хååץե̾
    ($fileDst) = ($fileSrc =~ m#.*\/([^\/]+)$#);
    $fileDst = "$dirname/$fileDst";

    # ХååоݥեΥॹ׼
    $mtime = (stat($fileSrc))[9];
    ($sec, $min, $hour, $day, $mon, $year) = localtime($mtime);
    $year += 1900;
    $mon++;

    # Хååץե̾$fileSrc + YYYYMMDD)
    $fileDst = sprintf("$fileDst.%04d%02d%02d", $year, $mon, $day);

    # եΰư
    $cmd = "$CMD_mv -f $fileSrc $fileDst";
    system("$cmd");

    # פʥХååץեκ
    $fileDst =~ s#\.\d+$##;
    @fileList = reverse(sort(<$fileDst.*>));
    for($i = 0; $i < $NUM_GBKBACKUP; $i++) {
        # ľ $NUM_GBKBACKUP Ĥ
        shift(@fileList);
    }
    foreach $filename (@fileList) {
        unlink("$filename");
    }

    return;
}
sub checkCompressed {
	my($fileDstExist,$fileSrc) = @_;
        if (! -e $fileDstExist) {
		if ($fileSrc =~ /\.(Z|gz)$/) {
			my $suf = $1;
			$fileDstExist =~ s/\.$suf$//;
			if (! -e $fileDstExist) {
				$fileDstExist = '';
			}
		} else {
			if (-e "$fileDstExist.gz") {
				$fileDstExist .= ".gz";
			} elsif (-e "$fileDst.Z") {
				$fileDstExist .= ".Z";
			} else {
				$fileDstExist = '';
			}
		}
	}
	$fileDstExist;
}

sub searchSubDir {
	my($dirDst, $dirSrc, $cnt, $dstFiles) = @_;
	my($chgnum) = 0;
 
        opendir(DH, $dirSrc) or die "Can not open source directory : $dirSrc :($!)";
        my @list = readdir(DH);
	closedir(DH);
	
        my $gbkfile = undef;
	foreach $f (@list) {
	 	next if ($f =~ /^\./);
        	next if ($f =~ /\.\./);
		if(-d $dirSrc."/".$f) {  # ǥ쥯ȥʤ饪ץ󤷤ƥեõ
                	if($cnt>0) {
                 		$chgnum += &searchSubDir($dirDst, $dirSrc."/".$f, $cnt-1, $dstFiles); 
                	}
			else { # ʾ忼õʤ
 			}
                }
        	else {
			if($f =~ /.*\.gbk/) {  # GenBankեξ硢ԡ¹Ԥ
				my($name) = ($f =~ /^(.+)\.gbk/);
				delete($dstFiles->{"$name"});
				$gbkfile = $f;
				$chgnum += &copyGBKFile($dirSrc, $dirDst, $gbkfile);
			}
		}
	}
	return $chgnum;
}

sub copyGBKFile {
	my($dirSrc, $dirDst, $file) = @_;
   	my($fileSrc);
    	my($fileDst);
    	my($gbkDef);
    	my($cmd);
    	my($chgnum)=0;

	# ԡоݤΥե.gbk
        $fileSrc = "$dirSrc/$file";
        $fileDst = "$dirDst/$file";
        $fileDstExist = &checkCompressed($fileDst,$fileSrc);

        if (! -e "$fileSrc") {
            # ʤԡΥե뤬ʤ
            print STDERR "WARNING :: File not found.($fileSrc)\n";
            return $chgnum;
        }
        if (-e "$dirDst/ignore/$file") {
            print STDERR "compare $fileSrc $dirDst/ignore/$file\n";
            system("$CMD_cmp -s $fileSrc $dirDst/ignore/$file");
#            if ( WIFEXITED($?) ) {
            if ( WIFEXITED($?) && (WEXITSTATUS($?) == 0) ) {
                print STDERR "Skip -- ignore/$file\n";
            	return $chgnum;
            }
        }

        if ($fileDstExist) {
            print STDERR "compare $fileSrc $fileDstExist\n";
            $cmd = "$CMD_cmp -s $fileSrc $fileDstExist";
            system("$cmd");
#            if ( WIFEXITED($?) ) {
            if ( WIFEXITED($?) && (WEXITSTATUS($?) == 0) ) {
                # no change
            	return $chgnum;
            }
        # եΥХååפ
            &BackupFile($fileDstExist, "$dirDst/old");
        }

        $chgnum++;

        # .gbk 򥳥ԡ
        # SGI(IRIX) Ǥ -p ץդ cp ¹Ԥ
	# ͭԤޤǥԡƤޤ
        # äơcp  touch ƥॹפ碌
        print STDERR "copy $fileDst\n";
        $cmd = "$CMD_cp $fileSrc $fileDst; $CMD_touch -r $fileSrc $fileDst";
        system("$cmd");

        # .faa
        $fileSrcGbk = $fileSrc; $fileDstGbk = $fileDst;
        foreach $suff ('faa', 'ptt', 'rnt', 'rpt', 'gff') {
                $fileSrc = $fileSrcGbk; $fileDst = $fileDstGbk;
                $fileSrc =~ s#.gbk#.$suff#; $fileDst =~ s#.gbk#.$suff#;
                $fileDstExist = &checkCompressed($fileDst,$fileSrc);
                &BackupFile($fileDstExist, "$dirDst/old");
                $cmd = "$CMD_cp $fileSrc $fileDst; $CMD_touch -r $fileSrc $fileDst";
                system("$cmd");
        }

        return $chgnum;
}

###############################################################################
if ($0 eq __FILE__) {
    my($refFuncUsage);
    my($dir);
    my($infoSpecTab);
    my($infoNew);
    my($infoSpecSta);
    my($hashref);
    my(@typeList, $type);

    # STDERR ˽ϤƤե˽
    &openLogfile($main::logfile);

    # Usage 
    $refFuncUsage = sub {
        print STDERR "Usage : $0 [DirFtpBacteria]\n";
    };

    if (scalar(@ARGV) == 0) {
        # FTP ǥ쥯ȥ꤬ꤵʤä ---> ǥեȤFTPǥ쥯ȥ
        push(@ARGV, $FTP_BACTERIA, $FTP_FUNGI);
    }

#    $dir             = shift(@ARGV);

    # SP  FTP ǥ쥯ȥȤбɤ߹
    if (! -e "$FILE_spidtab") {
        print STDERR "File not found($FILE_spidtab)\n";
        exit();
    }
    $infoSpecTab = &getInfoSpecTab($FILE_spidtab);

    my @spidList = sort(keys(%{$infoSpecTab->{'SPID2DIR'}}));
    foreach $spid (@spidList) {
        $spdir = $infoSpecTab->{'SPID2DIR'}->{"$spid"};
        if ($spid =~ /^\s*$/) {
            print STDERR "SKIP : Can not make copy(s) for '$spdir'.\n";
            next;
        }

        # GenBank ǡեΥԡ
        print STDERR "Checking $sp\n" if ($DEBUG);
        foreach my $dir (@ARGV) {
            if (-d "$dir/$spdir") {
                &CopyGbk($spid, "$dir/$spdir");
                last;
            }
        }
    }

    exit();
}

###############################################################################
1;#
###############################################################################
