#!/usr/bin/perl -s

###############################################################################
# ǡ١ϿƤƤʪñ̤˥Хååפ
# Хååפоݤϡʲ򤹤ʥǥեȡǿΥǡ
#     ǿΥǡ('last' Ȼؼ)
#     С(genome ơ֥ ver ؼ)
#
#
###############################################################################
use File::Path;
use FileHandle;
require "MBGD_Conf.pl";
require "libMBGDaxes.pl";
require "MBGD_commonUpdate.pl";

###############################################################################
#
sub BackupSpecInfo {
    my($dbname, $sp, $ver) = @_;
    my($infoGenome);
    my($infoChromosome);
    my($infoGene);
    my($genomeId);
    my(@chrIdList);
    my(@chrSeqList);
    my(@geneSeqList);
    my(@protSeqList);
    my($filename);
    my($fh);

    mkpath("$DIR_backup", 1, 0750);

    if ($ver =~ /^last$/i) {
        my($db) = MBGD::DB->new($dbname);
        my($opt) = {};
        my(@list) = MBGD::Genome->get($db, ["$sp"], $opt);

        # ǿΥСֹ
        $ver = "";
        foreach $ent (@list) {
            if ($ver < $ent->{'ver'}) {
                $ver = $ent->{'ver'};
            }
        }
    }
    if ($ver =~ /\\s*$/) {
        # ХååоݤΥǡʤ
        return;
    }

    # Genome ơ֥
    $infoGenome = &backupGenome($dbname, $sp, $ver);
    $genomeId = $infoGenome->{'INFO'}->[0];

    # chromosome ơ֥
    $infoChromosome = &backupChromosome($dbname, $genomeId);
    foreach $info (@{$infoChromosome->{'INFO'}}) {
        my($chrId, $chrSeq);
        $chrId  = $info->[0];
        $chrSeq = pop(@{$info});

        push(@chrIdList, $chrId);
        push(@chrSeqList, [$chrId, $chrSeq]);
    }

    # gene/geneseq/proteinseq ơ֥
    $infoGene = &backupGene($dbname, @chrIdList);
    foreach $info (@{$infoGene->{'INFO'}}) {
        my($geneId, $geneSeq);
        my($protId, $protSeq);

        $protId = $info->[13];
        $protSeq = pop(@{$info});
        push(@protSeqList, [$protId, $protSeq]);

        $geneId = $info->[12];
        $geneSeq = pop(@{$info});
        push(@geneSeqList, [$geneId, $geneSeq]);
    }


    # ̤ե˽(genome)
    $dbname = "genome";
    $filename = "$DIR_backup/$sp.$dbname.$ver";
    $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
    $fh->print(join("\t", @{$infoGenome->{'INFO'}}), "\n");
    $fh->close();

    # ̤ե˽(chromosome)
    $dbname = "chromosome";
    $filename = "$DIR_backup/$sp.$dbname.$ver";
    $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
    foreach $info (@{$infoChromosome->{'INFO'}}) {
        $fh->print(join("\t", @{$info}), "\n");
    }
    $fh->close();

    # ̤ե˽(dnaseq)
    $dbname = "dnaseq";
    $filename = "$DIR_backup/$sp.$dbname.$ver";
    $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
    foreach $info (@chrSeqList) {
        $fh->print(join("\t", @{$info}), "\n");
    }
    $fh->close();

    # ̤ե˽(gene)
    $dbname = "gene";
    $filename = "$DIR_backup/$sp.$dbname.$ver";
    $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
    foreach $info (@{$infoGene->{'INFO'}}) {
        $fh->print(join("\t", @{$info}), "\n");
    }
    $fh->close();

    # ̤ե˽(geneseq)
    $dbname = "geneseq";
    $filename = "$DIR_backup/$sp.$dbname.$ver";
    $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
    foreach $info (@geneSeqList) {
        $fh->print(join("\t", @{$info}), "\n");
    }
    $fh->close();

    # ̤ե˽(proteinseq)
    $dbname = "proteinseq";
    $filename = "$DIR_backup/$sp.$dbname.$ver";
    $fh = new FileHandle(">$filename") || die("Can not open $filename($!)");
    foreach $info (@protSeqList) {
        $fh->print(join("\t", @{$info}), "\n");
    }
    $fh->close();
}

###############################################################################
# genome Хåå
sub backupGenome {
    my($dbname, $sp, $ver) = @_;

    # MySQL  DB Ȥä
    my($db);
    my($sth);

    # DB ³
    $db = MBGD::DB->new($dbname);

    # 
    my($colms, $tables, $whereCond);
    $colms      = "*";
    $tables     = "genome";
    $whereCond  = "sp='$sp' and ver=$ver";

    # ǡ
    my($sql);
    $sql = "select $colms from $tables";
    $sql = "$sql where $whereCond"    if ($whereCond ne '');

    print STDERR "SQL :: $sql\n" if ($DEBUG);
    $sth = $db->execute("$sql");
    if (not $sth) {
        &MBGD_DbAccessError($sth, $sql);
        return undef();
    }

    # ̼
    my($rows);
    my($refRes);
    $rows = $sth->rows;
    $refRes->{'MAXROWS'} = $rows;
    $refRes->{'ROWS'} = $rows;
    $refRes->{'INFO'} = [];
    @{$refRes->{'INFO'}} = $sth->fetchrow_array;

    # λ
    $sth->finish;

    return $refRes;
}

###############################################################################
# chromosome Хåå
sub backupChromosome {
    my($dbname, $genome) = @_;

    # MySQL  DB Ȥä
    my($db);
    my($sth);

    # DB ³
    $db = MBGD::DB->new($dbname);

    # 
    my($colms, $tables, $whereCond);
    $colms      = "c.*, ds.seq";
    $tables     = "chromosome c, dnaseq ds";
    $whereCond  = "genome=$genome and c.seq=ds.id";

    # ǡ
    my($sql);
    $sql = "select $colms from $tables";
    $sql = "$sql where $whereCond"    if ($whereCond ne '');

    print STDERR "SQL :: $sql\n" if ($DEBUG);
    $sth = $db->execute("$sql");
    if (not $sth) {
        &MBGD_DbAccessError($sth, $sql);
        return undef();
    }

    # ̼
    my($rows);
    my($refRes);
    my($i);
    $rows = $sth->rows;
    $refRes->{'MAXROWS'} = $rows;
    $refRes->{'ROWS'} = $rows;
    $refRes->{'INFO'} = [];
    for($i = 0; $i < $rows; $i++) {
        my($info);

        $info = [];
        (@{$info}) = $sth->fetchrow_array;

        push(@{$refRes->{'INFO'}}, $info);
    }

    # λ
    $sth->finish;

    return $refRes;
}

###############################################################################
# gene Хåå
sub backupGene {
    my($dbname, @chrIdList) = @_;

    # MySQL  DB Ȥä
    my($db);
    my($sth);

    # DB ³
    $db = MBGD::DB->new($dbname);

    # 
    my($colms, $tables, $whereCond);
    $colms      = "g.*, gs.seq, ps.seq";
    $tables     = "gene g, geneseq gs, proteinseq ps";
    $whereCond  = "g.ntseq=gs.id and g.aaseq=ps.id and chrid in(" . join(',', @chrIdList) . ")";;

    # ǡ
    my($sql);
    $sql = "select $colms from $tables";
    $sql = "$sql where $whereCond"    if ($whereCond ne '');

    print STDERR "SQL :: $sql\n" if ($DEBUG);
    $sth = $db->execute("$sql");
    if (not $sth) {
        &MBGD_DbAccessError($sth, $sql);
        return undef();
    }

    # ̼
    my($rows);
    my($refRes);
    my($i);
    $rows = $sth->rows;
    $refRes->{'MAXROWS'} = $rows;
    $refRes->{'ROWS'} = $rows;
    $refRes->{'INFO'} = [];
    for($i = 0; $i < $rows; $i++) {
        my($info);

        $info = [];
        @{$info} = $sth->fetchrow_array;

        push(@{$refRes->{'INFO'}}, $info);
    }

    # λ
    $sth->finish;

    return $refRes;
}

###############################################################################
if ($0 eq __FILE__) {
    my($sp);

    # STDERR ˽ϤƤե˽
    &openLogfile($log);

    if (! $ver) {
        # version ꤵƤʤϡǿС
        $ver = 'last';
    }

    if (! $dbname) {
        $dbname = $main::MYSQL_DBACCUM;
    }

    foreach $sp (@ARGV) {
        # ѥǡ١ǡ
        &BackupSpecInfo($dbname, $sp, $ver);
    }
}

###############################################################################
1;#
###############################################################################
