#!/usr/bin/perl -s

use File::Path;
use FileHandle;
require "MBGD_common.pl";

if (! -e "$main::FILE_cdd_work.rps") {
    print STDERR "Can not found Cdd.\n";
    exit(0);
}

if (! defined $TMPDIR) {
#	$TMPDIR = "$MBGD_work";
	$TMPDIR = "$DIR_work";
}

if (! $OUTNAME) {
	$OUTNAME = "tmp_rps_$$";
	if ($TMPDIR) {
		$OUTNAME = "$TMPDIR/$OUTNAME";
	}
}

$blastout="$OUTNAME.mqblast";
$listfile="$OUTNAME.mdpin";
$outfile="$OUTNAME.mdpout";
$restfile="$OUTNAME.mdprest";
$resultfile="$OUTNAME.out";

$motdbfile = $main::FILE_cdd_work;
if (! defined $NAMELEN) {
	$NAMELEN = 22;	# the length of MD5 value; for check
}

$retainTmp = 1; # temporal
$retainTmp = 0 if ($deleteTmp);

$qseqfile=$ARGV[0];
$resultfile=$ARGV[1] if ($#ARGV >= 1);

die "Usage: $0 qseqfile\n" if (! $qseqfile);
if (! -f $qseqfile) {
    print STDERR "$0: $qseqfile: file not found\n";
    exit;
}
if (-z $qseqfile) {
    print STDERR "$0: $qseqfile: sequence not found\n";
    exit;
}

$ENV{'PATH'} .= ":/dbb/project/MBGD/package/mqblast";

if ($TMPDIR && ! -d $TMPDIR) {
	mkpath($TMPDIR) || die "Can't create directory: $TMPDIR\n";
}

if ($RETRY) {
	die "You must specify MQBLAST_TMPDIR\n" if (! $MQBLAST_TMPDIR);
	die "directory not exist: $MQBLAST_TMPDIR\n" if (! -d $MQBLAST_TMPDIR);
	$OTHEROPT .= "-ADD -TMPDIR='$MQBLAST_TMPDIR' ";
}
if ($retainTmp) {
	$OTHEROPT .= "-retainTmp ";
}

my($modeQsub) = '';
if ($main::CMD_qsub && -x $main::CMD_qsub) {
    $modeQsub = '-mode=qsub -CopyAll';
    $modeQsub .= " -DIR_nqs_pub=$DIR_nqs_pub";
    $modeQsub .= " -CMD_qsub=$CMD_qsub";
    $modeQsub .= " -CMD_qstat=$CMD_qstat";
    $modeQsub .= " -QUEUE_nqs=$NQS_queue" if ($NQS_queue);
}

$cmd = "$main::CMD_mqblast -OUTFILE='$blastout' "
#	 . "-CMD_rpsblast='$main::CMD_rpsblast' "
	 . "$modeQsub -CopyDB=0 -PROCNUM=$main::NUM_cpu "
	 . "-BLKSIZ=200 -BLASTOPT='-e 1' "
	 . "-CHECK -CHECK_NAMELEN1=$NAMELEN "
	 . "-PROGNAME='rpsblast' ";
if ($main::CMD_legacy_blast) {
	$cmd .= " -CMD_legacy_blast=$::CMD_legacy_blast";
}
$cmd .=  (" $OTHEROPT"
	 . " $motdbfile $qseqfile");
print STDERR ">>>$cmd\n";

system("$cmd");
die "mqblast failed\n" if ($?);

system("$main::CMD_convrps -FILE_CDD_ID=$main::FILE_cdd_id $blastout > $resultfile");

#unlink($blastout);
