#!/usr/bin/perl -s

###############################################################################
#
###############################################################################
require "MBGD_Conf.pl";
require "MBGD_commonUpdate.pl";
require "libMBGDaxes.pl";
require "libLoadInfo.pl";
require "InfoSpec.pl";

###############################################################################
#
sub CopyProtMotifInfoSpec {
    my($dbname, $dbnameAccum, @specList) = @_;
    my($db, $sql, $sth);
    my($whereSpec);
    my($all);

    #
    $all = 1 if (! @specList);

    #
    foreach $sp (@specList) {
        $sp = "'$sp'";
    }
    $whereSpec = join(',', @specList);

    $db = MBGD::DB->new($dbname);

###############################################################################
    print STDERR "makeing temporary table for MD5->SP:ORF conversion\n";
###############################################################################
#    $sql = "create temporary table md5sp type=HEAP "
    $sql = "create temporary table md5sp "
         . "select ps.chksum, genome.sp, g.name "
         . "from $dbname.proteinseq ps, $dbname.gene g, $dbname.genome "
         . "where ps.id=g.aaseq and g.sp=genome.sp";
	$sql .= "and genome.sp in ($whereSp)" if ($whereSp);
#    print STDERR "SQL :: $sql\n";
    $sth = $db->execute("$sql");
    $sth = $db->do("create index md5idx on md5sp(chksum)");

###############################################################################
    print STDERR "extracting and expanding protmotif data from $dbnameAccum\n";
###############################################################################
    # accum ʪꤷ protmotif ǡ
    my($col);
    $col  = "m.sp, m.name, p.from1, p.to1, ";
    $col .= "p.motlib, p.motid, mot.motname, p.program, ";
    $col .= "p.from2, p.to2, p.score, p.eval, mot.descr";

    if (! $all) {
        $ExpandSelect .= "select $col from md5sp m, $dbnameAccum.protmotif p, ";
        $ExpandSelect .= "$dbnameAccum.motif mot ";
        $ExpandSelect .= "where p.name=m.chksum ";
        $ExpandSelect .= "and mot.motlib=p.motlib and mot.motid=p.motid";

        $sql = "create temporary table tmp_protmotif "
             . "$ExpandSelect and m.sp in ($whereSpec) ";
        $sth = $db->execute("$sql");
    }

    my($tabname) = "ProtMotif";
    my($lcname) = lc($tabname);

### SKIP here when overwrite mode
###############################################################################
    if ($all || $main::add ne 'overwrite'){
        print STDERR "drop work table\n";

        $sth = $db->drop_tables($lcname);

#    	my($tabOpt) = {'tablename' => "$lcname",
#                   'create'    => 1};
#    	MBGD::DBTable->new($db, $tabname, $tabOpt);
        $db->create_table($tabname);
    }
###############################################################################
    if (! $all && $main::add ne 'overwrite'){
        print STDERR "copy protmotif table from the released database\n";
        $sql = "insert into $lcname select * from $UPD_dbnameRelease.$lcname";
        $sth = $db->execute("$sql");
    }
###############################################################################
    # Ÿоݤʪ
    print STDERR "insert data into table\n";
    if ($all) {
        $ExpandSelect = "select 0 id, p.udate, $col ";
        $ExpandSelect .= "from md5sp m, $dbnameAccum.protmotif p, ";
        $ExpandSelect .= "$dbnameAccum.motif mot ";
        $ExpandSelect .= "where p.name=m.chksum ";
        $ExpandSelect .= "and mot.motlib=p.motlib and mot.motid=p.motid";

        $sql  = "insert ignore into $lcname $ExpandSelect";
        $sth = $db->execute("$sql");
    } else {
        my($colList) = "sp, name, from1, to1, motlib, motid, motname, program, from2, to2, score, eval, descr";
        $sql = "delete from $lcname where sp in ($whereSpec);";
        $sth = $db->execute("$sql");

        # protmotif ̤ɲ
        $sql = "insert into $lcname ($colList) select $colList from tmp_protmotif;";
        $sth = $db->execute("$sql");
    }
#    print STDERR "SQL :: $sql\n";
    $sth = $db->execute("$sql");
    print STDERR "flush table\n";
    $db->flush_table($lcname);
}

#################################################################################
###
##sub CopyProtMotifInfoAll {
##    my($dbname) = @_;
##    my($db, $sql, $sth);
##    my($info);
##    my($filenameMd5);
##    my($filenameSp);
##    my($mot);
##    local(*FH);
##
##    # $DBNAME_ACCUM  protmotif ǡ
##    print STDERR "get protmotif data(MD5)\n";
##    $filenameMd5 = "$DIR_work/protmotifMd5.$$";
##    $cmd = "$main::CMD_mysql -q -D $DBNAME_ACCUM -e 'select * from protmotif'";
##    system("$cmd > $filenameMd5");
##
##    # MD5 ---> SP:ORF ŸSQL Ȼ֤ݤ뤿᥹ץȤǹԤ
##    print STDERR "convert MD5 ---> SP:ORF\n";
##    $filenameSp = "$DIR_work/protmotifSp.$$";
##    &ExpandProtmotif($filenameSp, $filenameM5);
##
##    $tabname = "ProtMotif";
##    my($lcname) = lc($tabname);
##
##    # DB ³
##    $db = MBGD::DB->new($dbname);
##
##    #
##    $sql = "drop table $lcname";
##    $sth = $db->execute("$sql");
##    if (not $sth) {
##        &MBGD_DbAccessError($sth, $sql);
##        return undef();
##    }
##
##    #
##    my($tabOpt) = {'tablename' => "$lcname",
##                   'create'    => 1};
##    my($tab) = MBGD::DBTable->new($db, $tabname, $tabOpt);
##
##    # ǡ١Ͽ
##    print STDERR "load protmotif data(SP:ORF)\n";
####    &MBGD_LoadDataInfileProtmotif($dbname, $filenameSp);
##    $tab->load_from_file($filenameSp);
## 
##
##    # եκ
##    unlink("$filenameSp");
##    unlink("$filenameMd5");
##
##    return;
##}
##
###############################################################################
#
##sub ExpandProtmotif {
##    my($outfile, @fileList) = @_;
##    my($info);
##    my($infoMd5);
##    my($filename);
##    my(@data);
##    my($sp);
##    my($md51);
##    my($orf);
##
##    # SP:ORF  MD5 б
##    $info = &MBGD_InfoSporfMd5();
##    $infoMd5 = $info->{'MD52SPORF'};
##
##    #
##    open(FO, ">$outfile") || die("Can not open $outfile($!)");
##
##    # protmotif (MD5)եɤ߹
##    foreach $filename (@fileList) {
##        open(FH, "$filename") || die("Can not open $filename($!)");
##	$header = <FH>;
##	@header = split(/\t/, $header);
##        while(<FH>) {
##            chomp();
##
##            ($id,$date,$name, = split(/\t/);
##            shift(@data);     # drop id
##            shift(@data);     # drop date
##            $sp   = shift(@data);
##            $md51 = shift(@data);
##
##            # NULL ǡϡ '\N' ֤
##            my($d);
##            foreach $d (@data) {
##                $d = '\N' if ($d eq '');
##            }
##
##            foreach $sporf1 (@{$infoMd5->{"$md51"}}) {
##                ($sp, $orf) = split(/:/, $sporf1);
##                print FO join("\t", $sp, $orf, @data), "\n";
##            }
##
##        }
##        close(FH);
##    }
##    close(FO);
##}
##
###############################################################################
if ($0 eq __FILE__) {

    # STDERR ˽ϤƤե˽
    &openLogfile($main::log);

    if (! $main::dbname) {
        $main::dbname = $main::DBNAME_WORK;
    }
    if (! $main::dbname_accum) {
        $main::dbname_accum = $main::DBNAME_ACCUM;
    }

    if ($main::add) {
        &CopyProtMotifInfoSpec($main::dbname, $main::dbname_accum, @ARGV);
    } else {
        &CopyProtMotifInfoSpec($main::dbname, $main::dbname_accum);
    }

    exit;
}

###############################################################################
1;#
###############################################################################
