#!/usr/bin/perl -s

use MBGD;
use MBGD::DB;
use File::Path;
use FileHandle;
require 'MBGD_Conf.pl';
require 'MBGD_commonUpdate.pl';
require "InfoSpec.pl";

#
# GetHomTab.pl [-OUT=bldp/blastdpres] [-PACK] [sp1 sp2 ...]
#

$PACK_TEMPL = "a30 a30 S S S S f f f f";
$dbname = $DBNAME_WORK if (! $dbname);
$db = MBGD::DB->new("dbi:mysql:$dbname;mysql_read_default_group=select_hom");
#$ORDER = 'score' if (! $ORDER);

$RBLKSIZ = 10000000 if (! $RBLKSIZ);
$WBUFSIZ = 800 if (! $WBUFSIZ);
$WBLKSIZ = 1000000 if (! $WBLKSIZ);
$BEGIN = 1 if (! $BEGIN);
$default_outname = 'blastdpres';
if ($skipdate) {
    $currtime = time;
    $skipdate0 = $currtime - $skipdate * 24 * 3600;
}

$dirBldp = "$DIR_work/bldp";

if ($upd) {
    $PACK = 1 if (! $NOPACK);
    if (! $OUT) {
        $OUT = "$dirBldp/$default_outname";
        File::Path::mkpath("$dirBldp");
        if (! $skipdate && ! $append) {
            foreach $f (<$OUT.*>) {
                unlink $f;
            }
        }
    }
    mkpath("$DIR_work/bldp");
}

my($recog_proj_ref) = RECOG::RecogProject->new();
my(@proj_id_list) = $recog_proj_ref->get_project_id_list();
if ($SPEC) {
    my(@species) = split(/,/, $SPEC);
    blastdpres(@species);
}
elsif (scalar(@proj_id_list) == 0) {
    my(@species);
    foreach my $spid (@ARGV) {
        my($sp) = spid2sp($spid);
        push(@species, $sp);
    }
    blastdpres(@species);
}
else {
    foreach my$proj_id (@proj_id_list) {
        my(@spid_list) = sort($recog_proj_ref->get_spid_list($user, $proj_id));
        my(@species);
        foreach my$spid (@spid_list) {
            my($sp) = spid2sp($spid);
            push(@species, $sp);
        }

        print STDERR "DBG :: $set_name :: @species\n";
        blastdpres(@species);
    }
}

exit(0);

###############################################################################
#
sub blastdpres {
    my(@species) = @_;

    #
    $total_read = 0;

    #
    my($WhereSpec);
    if (@species) {
        $speclist = "'" . join("','",@species) . "'";
        if ($WhereSpec) {
            $WhereSpec .= " and ";
        }
        $WhereSpec .= "sp1 in ( $speclist )";
        if ($both) {
            $WhereSpec .= " and sp2 in ( $speclist )";
        }
        else {
            $NeedSwap = 1;
        }
    }

    if ($WhereSpec) {
        $WhereSpec = "where $WhereSpec";
    }

    copyHomData($WhereSpec);
    print STDERR "Last...\n";
    write_homdata(1);

    return;
}

###############################################################################
#
sub getCount {
    my($WhereSpec) = shift;

    my($db) = MBGD::DB->new($dbname);
    my $sql = "select count(*) from homology h $WhereSpec";
    my($sth) = $db->execute("$sql");
    my($totalcnt) = $sth->fetchrow_array();

    return $totalcnt;
}

###############################################################################
#
sub copyHomData {
    my($WhereSpec) = @_;
    my($limit);
    if ($length) {
        print STDERR "$from,$length...\n";
        $limit = "limit $from,$length";
    }
    $colnames = "sp1,spname1,from1,to1,sp2,spname2,from2,to2," .
            "ident,eval,pam,score";
    $sql = "select $colnames from homology h $WhereSpec $limit";
    print STDERR "SQL :: [$dbname] :: $sql\n";
    open(SQL, "$main::CMD_mysql -B -q -w -e \"$sql\" $dbname|") || die;
    $cnt = 0;
    while(<SQL>) {
        if ($cnt++ == 0) {    ## skip head
            next;
        }
        $total_read++;
        chomp;
        my @array = split(/\t/);
        my($sp1,$sp2) = ($array[0],$array[4]);
        if ( ($sp1 cmp $sp2) > 0 ) {
            if ($NeedSwap){
                &swap(\$sp1,\$sp2);
            } else {
                next;
            }
        }
        push(@{$Buf{$sp1}->{$sp2}}, $_);
        if (! $limit) {
            $wcnt++;
            if ($wcnt % $WBLKSIZ==0) {
            print STDERR "$cnt,$wcnt\n";
            &write_homdata($WBUFSIZ);
            }
        }
    }
    close(SQL);
    if ($limit) {
        &write_homdata($WBUFSIZ);
    }
}

###############################################################################
#
sub write_homdata {
    my($wblksiz) = @_;
    my($outcnt);
    foreach my $sp1 (sort keys %Buf) {
        foreach my $sp2 (sort keys %{$Buf{$sp1}}) {
            if (@{$Buf{$sp1}->{$sp2}} >= $wblksiz) {
print STDERR "." if (++$outcnt % 100 == 0);
                &write_homdata_sp($sp1,$sp2);
            }
        }
    }
}

###############################################################################
#
sub write_homdata_sp {
    my($sp1,$sp2) = @_;
    if ($OUT) {
        $outfile = "$OUT.$sp1-$sp2";
        $outfile .= ".pack" if ($PACK);
        if ($skipdate0) {
            $mtime = (stat $outfile)[9];
            if ($mtime > $skipdate0) {
                return;
            }
        }
        if (! $append && ! $flag{$sp1,$sp2}) {
            open(OUT,">$outfile") || die "Can't open $outfile\n";
            $flag{$sp1,$sp2} = 1;
        } else {
            open(OUT,">>$outfile") || die "Can't open $outfile\n";
        }
    } else {
        open(OUT,">&STDOUT");
    }
    foreach my $h (@{$Buf{$sp1}->{$sp2}}) {
#        my($id,$udate,$sp1,$name1,$spname1,$from1,$to1,
#            $sp2,$name2,$spname2,$from2,$to2,
#            $ident,$eval,$pam,$score) = @{$h};

        my($sp01,$spname1,$from1,$to1, $sp02,$spname2,$from2,$to2,
            $ident,$eval,$pam,$score) = split(/\t/,$h);

        if ($NeedSwap){
            if ( ($sp01 cmp $sp02) > 0 ) {
                &swap(\$sp01,\$sp02);
                &swap(\$name1,\$name2);
                &swap(\$spname1,\$spname2);
                &swap(\$from1,\$from2);
                &swap(\$to1,\$to2);
            }
            next if ($found{$spname1,$spname2});
            $found{$spname1,$spname2} = 1;
        }
        if ($PACK) {
            print OUT pack($PACK_TEMPL,
            $spname1, $spname2,
            $from1, $to1, $from2, $to2,
            $ident, $eval,$score, $pam);
        }
        else {
            print OUT join(" ",
            $spname1, $spname2,
            $from1, $to1, $from2, $to2,
            $ident, $eval,$score, $pam) . "\n";
        }
    }
    delete $Buf{$sp1}->{$sp2};
    if ($OUT) {
        close(OUT);
    }
}

###############################################################################
#
sub swap {
    my($a, $b)= @_;
    my($tmp);
    $tmp = $$a; $$a=$$b; $$b = $tmp;
}

1;
