#!/usr/bin/perl -s
use FileHandle;
use MBGD;
use MBGD::DB;
require "MBGD_Conf.pl";
require "MBGD_commonUpdate.pl";
require "libMBGDaxes.pl";

sub writeFuncCategory {
    my($db) = shift;
    my($sp) = shift;

    foreach my$fdb ('mbgd', 'cog', 'kegg', 'tigr') {
        my($file) = "$ENV{'MBGD_HOME'}/database.work/function/$fdb/geneFunction.$sp.all";
        my($fh) = new FileHandle(">$file");
        if (! $fh) {
            print STDERR "Can not open $file($!)\n";
            next;
        }

        my($tab) = "cluster_all c, clusttab_all ct";
        my($opt) = {};
        $opt->{'columns'} = "c.name as name, ct.class as class";
        $opt->{'where'} = "c.sp='$sp' and c.clustid=ct.clustid and ct.dbname='$fdb'";
        $opt->{'order'} = "c.name";

        my($refRes) = $db->select_fetch($tab, $opt);
        foreach my$ref (@{$refRes->{'INFO'}}) {
            $fh->print(join("\t", $sp, $ref->{'name'}, $fdb, $ref->{'class'}), "\n");
        }

        $fh->close();

        my($sql) = "load data local infile '$file' into table function.gene_category (sp, name, dbname, level)";
        $db->do($sql); 
   }

    return;
}

if ($0 eq __FILE__) {
    if (! $main::DATABASE_DIR) {
        $main::DATABASE_DIR = "$main::DIR_database.work";
    }

    if (! $main::dbname) {
        $main::dbname = $main::UPD_dbiTmp;
    }
    my($db) = new MBGD::DB($main::dbname);
    my($sql) = "delete from function.gene_category where is_orig is null;";
    $db->do($sql);

    foreach my$sp (MBGD_SpecTableGetAllSpec("$main::DATABASE_DIR")) {
        writeFuncCategory($db, $sp);
    }
}

1;#
