#!/usr/bin/perl -s

use DirHandle;
require "libCheckPoint.pl";

###############################################################################
if ($0 eq __FILE__) {
    my($dh);
    my($file);

# delte checkpoint files
    &clearCheckPoint();

# delte temporary files
    $dh = new DirHandle("$DIR_work") || die("Can not open $DIR_work($!)");
    foreach $file ($dh->read()) {
        if (($file =~ /^query\.\d+/) ||    # query and results of homology search
            ($file =~ /^blastdb$/)   ||    # blastdb for build data
            ($file =~ /^blastdb\.p.+$/) || # blastdb for build data
            ($file =~ /^newprotseq$/) ||   # protseq for build data
            ($file =~ /^tmphom_\d*/) ||             # homology for build data
            ($file =~ /^homology.blastdpres$/) ||   # homology for build data
            ($file =~ /^homologyMd5.\d+$/) ||       # homology for build data
            ($file =~ /^homologySp.\d+\_\d+$/) ||   # homology for build data
            ($file =~ /^Temp_\d+_\d+$/) || # htblast 
            ($file =~ /^out\.\d+_\d+$/)) { # htblast

            if ($main::DEBUG) {
                print STDERR "unlink :: $main::DIR_work/$file\n";
            }
            else {
                unlink("$main::DIR_work/$file");
            }
        }
    }

    exit;
}

###############################################################################
1;#
###############################################################################
