#!/usr/bin/perl -s
use strict;
use File::Path;
use FileHandle;
require "MBGD_Conf.pl";
require "InfoSpec.pl";

$main::url = "http://mbgd.genome.ad.jp/data/species";
$main::url = $main::URL if ($main::URL);

################################################################################
sub print_usage {
    print STDERR "Usage :: $0  [-UPD_LIST_SPEC]  [-CLEAR]  \n";

    return;
}

################################################################################
sub exec_mirror {
    my($adrs) = shift;
    my($file_out) = shift;

    my($cmd) = "$main::CMD_curl -s -w '%{http_code}' -L -o $file_out $adrs";
    my($sta_http) = `$cmd`;
    if ($sta_http != 200) {
#        print("$file_out\n");
	print STDERR "exec_mirror: fail to transfer: $adrs: $file_out\n";
        #unlink("$file_out");
	rename $file_out, "${file_out}.err";
        return $sta_http;
    }

    return;
}

################################################################################
sub mirrorSpidData {
    my($spid) = shift;
    my($sp) = shift;
    my($u);
    my($f);
    my($cmd);

    #
    my($dir_spid) = sprintf("%s/species/%s", $ENV{'MBGD_HOME'}, $spid);
    my($dir_sp)   = sprintf("%s/species/%s", $ENV{'MBGD_HOME'}, $sp);

    #
    my($dir) = sprintf("%s/species/%s/gm", $ENV{'MBGD_HOME'}, $spid);
    rmtree("$dir/data") if ($main::CLEAR);
    mkpath("$dir/data", 0, 0750);
    if (! -e "$dir_sp") {
        symlink($dir_spid, $dir_sp);
    }

    # $dir/genome
    $u = sprintf("$main::url/%s/gm/genome.txt", $spid);
    $f = sprintf("%s/genome.txt", $dir);
    my $ret = exec_mirror($u, $f);
    if ($main::UPD_LIST_SPEC) {
        return;
    }
	

    # $dir/data/filelist
    $u = sprintf("$main::url/%s/gm/data/filelist", $spid);
    $f = sprintf("%s/data/filelist", $dir);
    exec_mirror($u, $f);

    # $dir/data/*
    my($filename) = $f;
    my($fh) = FileHandle->new("$filename") || die("Can not open $filename($!)");
    while(my$file=$fh->getline) {
        next if ($file =~ /^\s*$/);

        $file =~ s#[\r\n]*$##;
        $u = sprintf("$main::url/%s/gm/data/$file", $spid);
        $f = sprintf("%s/data/$file", $dir);
        exec_mirror($u, $f);
	unless(-e $f) {
	    new FileHandle(">$f");
	}
    }

    # $dir/gene_category.$dbname
    foreach my$dbname ('mbgd', 'cog', 'kegg', 'tigr') {
        $u = sprintf("$main::url/%s/gm/geneFunction.$sp.$dbname", $spid);
        $f = sprintf("%s/geneFunction.$sp.$dbname", $dir);
        exec_mirror($u, $f);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my(@spid_list) = @ARGV;

    #
    print STDERR "Update spid.tab.dist\n";
    my($u) = "$main::url/spid.tab.dist";
    my($fileSpidDist) = "$main::FILE_spidtab.dist";
    if (! -f $fileSpidDist) {
    	my($cmd) = "$main::CMD_curl -L -o $fileSpidDist $u";
    	system("$cmd");
    }
    my($refSpidDist) = getInfoSpecTab($fileSpidDist);

    #
    my($fileSpidTab) = "$main::FILE_spidtab";
    my($refSpidTab) = getInfoSpecTab($fileSpidTab);

    if ($main::UPD_LIST_SPEC) {
        push(@spid_list, keys(%{$refSpidDist->{'SPID2NAME'}}));
    }
    elsif ($main::SPIDTAB) {
        push(@spid_list, keys(%{$refSpidTab->{'SPID2NAME'}}));
    }

    #
    my(%spid_hash);
    foreach my$spid (@spid_list) {
        if ($spid !~ /^g[md]\d{5}$/) {
            print STDERR "WARNING :: Illegal spid format [$spid]\n";
            if (!exists($refSpidDist->{'NAME2SPID'}->{"$spid"})) {
                next;
            }
            my($spid_new) = $refSpidDist->{'NAME2SPID'}->{"$spid"};
            print STDERR "LOG :: $spid ==> $spid_new\n";
            $spid = $spid_new;
        }

        $spid_hash{"$spid"} = 1;
    }
    @spid_list = sort(keys(%spid_hash));

    #
    foreach my$spid (@spid_list) {
        print STDERR "Download $spid\n";
        mirrorSpidData($spid, $refSpidDist->{'SPID2NAME'}->{"$spid"});
        copyInfoSpecTabEntry($refSpidDist, $refSpidTab, $spid);
    }

    if (!$main::UPD_LIST_SPEC) {
        setInfoSpecTab($fileSpidTab, $refSpidTab);
    }
}

1;#
