CREATE TABLE proteinseq (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  md5sum VARCHAR(22) NOT NULL,
  seq_length INTEGER UNSIGNED NOT NULL,
  seq MEDIUMTEXT NOT NULL,
  PRIMARY KEY(id),
  UNIQUE INDEX proteinseq_unique_md5(md5sum)
);

CREATE TABLE reference (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  medid INTEGER UNSIGNED NULL,
  journal VARCHAR(60) NULL,
  PRIMARY KEY(id)
);

CREATE TABLE institution (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  name VARCHAR(100) NOT NULL,
  wwwlink VARCHAR(200) NULL,
  PRIMARY KEY(id),
  UNIQUE INDEX institution_unique_name(name)
);

CREATE TABLE organism (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  orgname VARCHAR(60) NULL,
  abbrev VARCHAR(30) NULL,
  strain VARCHAR(30) NULL,
  taxid INTEGER UNSIGNED NULL,
  specweight INTEGER UNSIGNED NULL,
  PRIMARY KEY(id),
  UNIQUE INDEX organism_unique_orgname_strain(orgname, strain)
);

CREATE TABLE dnaseq (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  md5sum VARCHAR(22) NOT NULL,
  seq_length INTEGER UNSIGNED NOT NULL,
  seq LONGTEXT NOT NULL,
  PRIMARY KEY(id),
  UNIQUE INDEX dnaseq_unique_md5(md5sum)
);

CREATE TABLE environment (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  environ TEXT NULL,
  PRIMARY KEY(id)
);

CREATE TABLE gene (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  spid VARCHAR(7) NOT NULL,
  locus_tag VARCHAR(32) NOT NULL,
  name VARCHAR(24) NULL,
  geneid INTEGER UNSIGNED NULL,
  descr VARCHAR(250) NULL,
  PRIMARY KEY(id),
  UNIQUE INDEX gene_unique_geneset_locus(spid, locus_tag)
);

CREATE TABLE seqreg (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  dnaseq_id INTEGER UNSIGNED NOT NULL,
  name VARCHAR(20) NULL,
  source_db VARCHAR(20) NULL,
  source_id VARCHAR(20) NULL,
  type VARCHAR(20) NULL,
  PRIMARY KEY(id),
  INDEX seqreg_FKIndex1(dnaseq_id)
);

CREATE TABLE organnot (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  organism_id INTEGER UNSIGNED NOT NULL,
  PRIMARY KEY(id),
  INDEX organnot_FKIndex1(organism_id)
);

CREATE TABLE geneannot (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  gene_id INTEGER UNSIGNED NOT NULL,
  PRIMARY KEY(id),
  INDEX geneannot_FKIndex1(gene_id)
);

CREATE TABLE location (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  seqreg_id INTEGER UNSIGNED NOT NULL,
  from1 INTEGER UNSIGNED NULL,
  to1 INTEGER UNSIGNED NULL,
  dir1 INTEGER NULL,
  ex_from1 SMALLINT UNSIGNED NULL DEFAULT 1,
  ex_to1 SMALLINT UNSIGNED NULL DEFAULT 1,
  seqreg_id2 INTEGER UNSIGNED NULL,
  PRIMARY KEY(id),
  INDEX location_FKIndex1(seqreg_id)
);

CREATE TABLE chromosome (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  seqreg_id INTEGER UNSIGNED NOT NULL,
  source VARCHAR(20) NULL,
  name VARCHAR(12) NOT NULL,
  seqno INTEGER UNSIGNED NOT NULL,
  type VARCHAR(20) NULL,
  shape VARCHAR(10) NOT NULL,
  status VARCHAR(10) NULL,
  PRIMARY KEY(id),
  UNIQUE INDEX chromosome_FKIndex2(seqreg_id)
);

CREATE TABLE transcript (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  gene_id INTEGER UNSIGNED NOT NULL,
  seqreg_id INTEGER UNSIGNED NOT NULL,
  proteinseq_id INTEGER UNSIGNED NOT NULL,
  type VARCHAR(10) NOT NULL,
  seqno SMALLINT UNSIGNED NOT NULL,
  protid VARCHAR(20) NULL,
  gi INTEGER UNSIGNED NULL,
  transl_table TINYINT UNSIGNED NULL,
  codon_start TINYINT UNSIGNED NULL,
  product VARCHAR(250) NULL,
  user_def VARCHAR(250) NULL,
  PRIMARY KEY(id),
  INDEX transcript_FKIndex(proteinseq_id),
  INDEX transcript_FKIndex2(seqreg_id),
  INDEX transcript_FKIndex3(gene_id)
);

CREATE TABLE project (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  institution_id INTEGER UNSIGNED NOT NULL,
  organism_id INTEGER UNSIGNED NULL,
  environment_id INTEGER UNSIGNED NULL,
  sp VARCHAR(7) NOT NULL,
  spid VARCHAR(7) NOT NULL,
  source VARCHAR(20) NULL,
  type VARCHAR(20) NULL,
  wwwlink VARCHAR(200) NULL,
  date_release DATE NULL,
  date_modify DATE NULL,
  mbgd_update DATE NULL,
  PRIMARY KEY(id),
  INDEX project_FKIndex1(environment_id),
  INDEX project_FKIndex2(organism_id),
  INDEX project_FKIndex3(institution_id),
  UNIQUE INDEX project_unique_spid(spid)
);

CREATE TABLE location_info (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  location_id INTEGER UNSIGNED NOT NULL,
  location_text TEXT NULL,
  PRIMARY KEY(id),
  INDEX location_info_FKIndex1(location_id)
);

CREATE TABLE geneset (
  id INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  udate TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  project_id INTEGER UNSIGNED NOT NULL,
  ver INTEGER UNSIGNED NOT NULL,
  selected SMALLINT UNSIGNED NULL,
  PRIMARY KEY(id),
  INDEX geneset_FKIndex1(project_id),
  UNIQUE INDEX geneset_unique_project_ver(project_id, ver)
);

CREATE TABLE project_has_ref (
  reference_id INTEGER UNSIGNED NOT NULL,
  project_id INTEGER UNSIGNED NOT NULL,
  INDEX project_has_ref_FKIndex1(project_id),
  INDEX project_has_ref_FKIndex2(reference_id)
);

CREATE TABLE geneset_gene (
  gene_id INTEGER UNSIGNED NOT NULL,
  geneset_id INTEGER UNSIGNED NOT NULL,
  INDEX geneset_gene_FKIndex1(geneset_id),
  INDEX geneset_gene_FKIndex2(gene_id),
  PRIMARY KEY(gene_id, geneset_id)
);

CREATE TABLE geneset_chromosome (
  geneset_id INTEGER UNSIGNED NOT NULL,
  chromosome_id INTEGER UNSIGNED NOT NULL,
  INDEX geneset_chromosome_FKIndex1(geneset_id),
  INDEX geneset_chromosome_FKIndex2(chromosome_id),
  PRIMARY KEY(geneset_id, chromosome_id)
);

CREATE TABLE gene_prop_info (
  id        int(10) unsigned NOT NULL AUTO_INCREMENT,
  prop_name varchar(50) NOT NULL,
  type      varchar(16) DEFAULT NULL,
  elm_ext   text,
  is_multi  int(11) DEFAULT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY idx_prop_name (prop_name)
);

CREATE TABLE gene_prop (
  id            int(10) unsigned NOT NULL AUTO_INCREMENT,
  recog_user_id int(10) unsigned          DEFAULT NULL,
  udate         timestamp        NOT NULL DEFAULT CURRENT_TIMESTAMP,
  sp            varchar(7)       NOT NULL,
  name          varchar(32)      NOT NULL,
  prop_name     varchar(50)      NOT NULL,
  type          varchar(8)       NOT NULL,
  c_val         varchar(128)     NOT NULL,
  n_val         float            NOT NULL,
  PRIMARY KEY (id),
  KEY sp (sp, name, prop_name)
);

CREATE TABLE gene_set (
  recog_user_id int(10) unsigned     DEFAULT NULL,
  udate         timestamp   NOT NULL DEFAULT CURRENT_TIMESTAMP,
  set_name      varchar(50) NOT NULL,
  set_val       text        NOT NULL,
  set_size      int(11)              DEFAULT NULL,
  set_spec      text,
  KEY idx_tabid_clustid_prop_name (set_name)
);

CREATE TABLE cluster_prop_info (
  id        int(10) unsigned NOT NULL AUTO_INCREMENT,
  tabid     varchar(50)      NOT NULL,
  prop_name varchar(50)      NOT NULL,
  type      varchar(8)       NOT NULL,
  elm_ext   text,
  is_multi  int(11) DEFAULT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY idx_tabid_prop_name (tabid, prop_name)
);

CREATE TABLE cluster_prop (
  recog_user_id int(10) unsigned      DEFAULT NULL,
  udate         timestamp    NOT NULL DEFAULT CURRENT_TIMESTAMP,
  tabid         varchar(50)  NOT NULL,
  clustid       int(11)      NOT NULL,
  subclustid    int(11)      NOT NULL,
  prop_name     varchar(50)  NOT NULL,
  c_val         varchar(128) NOT NULL,
  n_val         float        NOT NULL,
  KEY idx_tabid_clustid_prop_name (tabid, clustid, prop_name)
);

CREATE TABLE cluster_set (
  recog_user_id int(10) unsigned     DEFAULT NULL,
  udate         timestamp   NOT NULL DEFAULT CURRENT_TIMESTAMP,
  tabid         varchar(50) NOT NULL,
  set_name      varchar(50) NOT NULL,
  set_val       text        NOT NULL,
  set_size      int(11)              DEFAULT NULL,
  KEY idx_tabid_clustid_prop_name (tabid, set_name)
);

CREATE TABLE motif (
  id      int(11) NOT NULL AUTO_INCREMENT,
  udate   timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  motlib  varchar(12)  NOT NULL DEFAULT '',
  motid   varchar(14)  NOT NULL DEFAULT '',
  motname varchar(40)  DEFAULT NULL,
  program varchar(12)  DEFAULT NULL,
  length  int(11)      DEFAULT NULL,
  descr   varchar(250) DEFAULT NULL,
  PRIMARY KEY (motlib, motid),
  UNIQUE KEY id (id),
  FULLTEXT KEY motif_idx_descr (descr)
);
