create table if not exists cluster_taxmap_index (
  id          int         not null auto_increment,
  udate       timestamp   not null default current_timestamp on update current_timestamp,
  dumpid      varchar(50) not null,
  clustid     varchar(50) not null,
  mapspecid   varchar(50) not null,
  mapspec     varchar(128) not null,
  primary key (id)
);

CREATE TABLE project_domclust (
  proj_id    int NOT NULL,
  clusttabid varchar(50)  NOT NULL DEFAULT '',
  name       varchar(100) NOT NULL DEFAULT '',
  descr      text NOT NULL,
  view_opts  text NOT NULL,
  cdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (proj_id, clusttabid, name)
);

CREATE TABLE project_phylopat (
  proj_id    int NOT NULL,
  clusttabid varchar(50) NOT NULL DEFAULT '',
  phylopatid varchar(50) NOT NULL DEFAULT '',
  name       varchar(100) NOT NULL DEFAULT '',
  descr      text NOT NULL,
  cdate      timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (proj_id, clusttabid, phylopatid, name)
);

CREATE TABLE project_core (
  proj_id    int NOT NULL,
  clusttabid varchar(50)  NOT NULL DEFAULT '',
  coreid     varchar(50)  NOT NULL DEFAULT '',
  name       varchar(100) NOT NULL DEFAULT '',
  descr      text NOT NULL,
  cdate      timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (proj_id, clusttabid, coreid, name)
);

