#!/usr/bin/perl -s
use strict;
use MBGD::DB;
require "MBGD_common.pl";
require "InfoSpec.pl";

###############################################################################
#
sub print_usage {
    print STDERR "Usage :: $0 spid1 [ spid2 ... spidN ]\n";

    return;
}

###############################################################################
#
sub removeUserGenomeData {
    my($db) = shift;
    my($spid) = shift;

    my($tabd, $tabu);
    my($where);
    my($sql);
    my($sth);

    #
    $tabd = 'transcript';
    $tabu = 'gene, transcript';
    $where = "gene.spid='$spid' and gene.id=transcript.gene_id";
    $sql = "delete from $tabd using $tabu where $where";
    $db->execute($sql);

    #
    $tabd = 'gene';
    $tabu = 'gene';
    $where = "gene.spid='$spid'";
    $sql = "delete from $tabd using $tabu where $where";
    $db->execute($sql);

    #
    $tabd = 'geneset_gene';
    $tabu = 'project, geneset, geneset_gene';
    $where = "project.spid='$spid' and project.id=geneset.project_id and geneset.id=geneset_gene.geneset_id";
    $sql = "delete from $tabd using $tabu where $where";
    $db->execute($sql);

    #
    $tabd = 'chromosome';
    $tabu = 'project, geneset, geneset_chromosome, chromosome';
    $where = "project.spid='$spid' and project.id=geneset.project_id and geneset.id=geneset_chromosome.geneset_id and geneset_chromosome.chromosome_id=chromosome.id";
    $sql = "delete $tabd from $tabu where $where";
    $db->execute($sql);

    #
    $tabd = 'geneset_chromosome';
    $tabu = 'project, geneset, geneset_chromosome';
    $where = "project.spid='$spid' and project.id=geneset.project_id and geneset.id=geneset_chromosome.geneset_id";
    $sql = "delete from $tabd using $tabu where $where";
    $db->execute($sql);

    #
    $tabd = 'geneset';
    $tabu = 'project, geneset';
    $where = "project.spid='$spid' and project.id=geneset.project_id";
    $sql = "delete from $tabd using $tabu where $where";
    $db->execute($sql);

    #
    $tabd = 'environment';
    $tabu = 'project, environment';
    $where = "project.spid='$spid' and project.environment_id=environment.id";
    $sql = "delete from $tabd using $tabu where $where";
    $db->execute($sql);

    #
    $tabd = 'organism';
    $tabu = 'project, organism';
    $where = "project.spid='$spid' and project.organism_id=organism.id";
    $sql = "delete from $tabd using $tabu where $where";
    $db->execute($sql);

    #
    $tabd = 'project';
    $tabu = 'project';
    $where = "project.spid='$spid'";
    $sql = "delete from $tabd using $tabu where $where";
    $db->execute($sql);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    if (scalar(@ARGV) == 0) {
        print_usage();
        exit(0);
    }

    my($dbname) = $main::DBNAME_ACCUM;
    if (defined($main::DBNAME)) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);
    foreach my$spid (@ARGV) {
        print STDERR "Remove '$spid' from $dbname\n";
        removeUserGenomeData($db, $spid);
    }
}
1;#

