#!/usr/bin/perl -s
use strict;
use MBGD;
use MbgdUserGenomeCommon;

###############################################################################
if ($0 eq __FILE__) {
    if (! $main::uid) {
        print STDERR "Usage :: $0 -uid=UID sp1 [...]\n";
        exit(0);
    }

    my($dbname) = MbgdUserGenomeCommon::getDbname($main::uid);
    if (($dbname =~ /^$main::DBNAME_MBGD$/i) ||
        ($dbname =~ /^$main::DBNAME_ACCUM$/i)) {
        die("Can not use this database('$dbname').");
    }
    if (! /^mbgd_\d+\_\d+$/) {
        die("Illegal database('$dbname').");
    }
    my($db) = new MBGD::DB($dbname);

    foreach my$sp (@ARGV) {
        if ($main::HOMOLOGY) {
            # $B%[%b%m%8!<8!:w7k2L$N:o=|(B
            clearHomologySearchRes($db, $sp);

            # $B%[%b%m%8!<8!:w7k2L>u67(B
	        MbgdUserGenomeCommon::clearBlastFinishedSpec($main::uid, $sp);
        }

        if ($main::MOTIF) {
            # $B%b%A!<%U8!:w7k2L$N:o=|(B
            clearMotifSearchRes($db, $sp);
        }

        if ($main::CLUSTER) {
            # $B%/%i%9%?%j%s%07k2L$N:o=|(B
            clearAllClusteringRes($db, $sp);
        }
    }
}

###############################################################################
1;#
###############################################################################
