#!/usr/bin/perl -s
use strict;
use MBGD;
use MBGD::DB;

# MySQL $B$K(B database $B$r:n@.$7$F$$$k%f!<%6$N(B UID $B$N%j%9%H$rJV$9(B
sub getUidForMymbgd {
    my($db) = new MBGD::DB();
    my(@uid);

    my($sql) = "show databases";
    my($sth) = $db->execute($sql);
    while(my@d = $sth->fetchrow_array) {
        foreach my$d (@d) {
            if ($d =~ /^mbgd\_(\d+\_\d+)$/) {
                push(@uid, $1);
            }
        }
    }

    return @uid;
}

sub updMymbgdTables {
    my($uid) = shift;
    my($dbname) = "mbgd_$uid";
    my($sta);
    my($sql);

    if ($uid !~ /^\d+\_\d+$/i) {
        print STDERR "WARNING :: UID is wrong format :: $uid\n";
        return;
    }
    if ($dbname =~ /^$main::DBNAME_MBGD$/i) {
        print STDERR "WARNING :: dbname is '$main::DBNAME_MBGD'\n";
        return;
    }
    if ($dbname =~ /^$main::DBNAME_ACCUM$/i) {
        print STDERR "WARNING :: dbname is '$main::DBNAME_ACCUM'\n";
        return;
    }
    if ($dbname =~ /^$main::DBNAME_WORK$/i) {
        print STDERR "WARNING :: dbname is '$main::DBNAME_WORK'\n";
        return;
    }

    print STDERR "START :: UID :: $uid\n";
    my($db) = new MBGD::DB($dbname);
    if (! $db->{'conn'}) {
        print STDERR "SKIP :: no database for $uid\n";
        return;
    }

    my($tab) = 'genome_user';
    $sta = $db->exist_table($tab);
    if (! $sta) {
        print STDERR "SKIP :: no table(genome_user)\n";
        return;
    }

    foreach my$f ('date_release', 'date_modify', 'mbgd_update') {
        $sql = "alter table genome_user add $f date default NULL;";
        $sta = $db->do($sql);
#        if (! $sta) {
#            print STDERR "WARNING :: can not add field($f)\n";
#            return;
#        }
    }

    # MERGE $B%F!<%V%k$r:n$jD>$9(B
    $sql = "drop table IF EXISTS genome;";
    $sta = $db->do($sql);
#    if (! $sta) {
#        print STDERR "ERROR :: can not drop merge-table\n";
#        return;
#    }


    $sql = "
CREATE TABLE `genome` (
  `id` int(11) NOT NULL auto_increment,
  `udate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ver` smallint(6) NOT NULL default '0',
  `status` smallint(6) default NULL,
  `sp` varchar($::SIZE_SP) NOT NULL default '',
  `abbrev` varchar(30) default NULL,
  `orgname` varchar(60) default NULL,
  `strain` varchar(30) default NULL,
  `taxid` int(11) default NULL,
  `source` varchar(20) default NULL,
  `institution` varchar(100) default NULL,
  `wwwlink` varchar(200) default NULL,
  `medid` varchar(10) default NULL,
  `journal` varchar(60) default NULL,
  `date_release` date default NULL,
  `date_modify` date default NULL,
  `mbgd_update` date default NULL,
  PRIMARY KEY  (`sp`,`ver`),
  UNIQUE KEY `genome_idx_id` (`id`)
) ENGINE=MRG_MyISAM DEFAULT CHARSET=latin1 INSERT_METHOD=LAST UNION=(`mbgd`.`genome`,`genome_user`);
";

    # 
    $sta = $db->do($sql);
#    if (! $sta) {
#        print STDERR "ERROR :: can not create merge-table)\n";
#        return;
#    }

    print STDERR "END :: UID :: $uid\n";
}

if ($0 eq __FILE__) {
    my($uid);
    my(@uidList);

    if ($main::MYSQL) {
        @uidList = getUidForMymbgd();
    }

    foreach $uid (@uidList, @ARGV) {
        updMymbgdTables($uid);
    }
}
