#ifndef _CLUSTER_TREE_H_
#define _CLUSTER_TREE_H_
#include "Tree.h"
#include "ClusterNode.h"
using namespace std;

class ClusterTree : public BaseTree {
	void printTreeDetail_sub(ClusterNode *node, ClusterNode *parent);
	static ClusterNode *convClusterTree_sub(TreeNode *tree);
public:
        enum OutStyle {
                NORMALOUT, TREEOUT, NEWICK, NEWICK_DIST, HIER_DETAILOUT,
                        CLUSTTAB, GRAPHOUT, NEIGHBOR, DOMAINOUT, TABOUT, DUMP,
                        TREEDETAIL
        } outputStyle;

	ClusterTree(ClusterNode *root, string name="");
	void phyloCut(double cutoff, SpecSet *chkSpSet=NULL);
	int scoreCut(double cutoff, SpecSet *newSpSet=NULL);
	void output(int outStyle);
	void printTree();
	void printTree(ClusterNode *node);
	void printTreeDetail();
	ClusterNode *getRoot() { return dynamic_cast<ClusterNode*>(BaseTree::getRoot()); }
	void outputScore(FILE *fp = NULL, const char *str = NULL);
	static ClusterTree *convClusterTree(DistTree *tree);
};
#endif
