#ifndef _DISTMAT_H_
#define _DISTMAT_H_
#include <iostream>
#include <vector>
#include <cfloat>
#include "HomData.h"
#include "BinQueue.hpp"
#include "PairDist.h"
#include "MemAlloc.hpp"
#include "SimValue.h"


class DistData {
	int id;
	PairDist *pdist;
public:
	DistData() { }
	DistData(int _id, PairDist *_pdist) : id(_id), pdist(_pdist) {}
	int getID() {
		return id;
	}
	PairDist* getPairDist() {
		return pdist;
	}
	double getDist() {
		return pdist->getDist();
	}
	struct cmpDistDataByID {
		bool operator()
			(DistData* const &d1, DistData* const &d2) const {
			return(d1->getID() < d2->getID());
		}
	};
	struct cmpDistDataByDist {
		bool operator()
			(DistData* const &d1, DistData* const &d2) const {
			return(d1->getDist() < d2->getDist());
		}
	};
	friend ostream& operator<<(ostream& ost, const DistData& d) {
		return(ost << d.id << " " << *d.pdist);
	}
};

class NodeNbrList {
	list<PairDist *> nbrList;
public:
	NodeNbrList() { }
	void add(PairDist *pdist) {
		nbrList.push_back(pdist);
	}
	list<PairDist*>::iterator begin() {
		return nbrList.begin();
	}
	list<PairDist*>::iterator end() {
		return nbrList.end();
	}
	int size() {
		return nbrList.size();
	}
	void checkDeleted();
};
// class for maintaining node indices
class NodeIndex {
	MemAlloc<DistData> distDataPool;
	vector< vector<DistData *>* > indexTmp;
	vector<NodeNbrList *> index;
	void addData_preproc(int id1, int id2, PairDist *pd);
	void addData_clustering(int id, PairDist *pd);
	enum Status {INITIALIZE, CLUSTERING} status;
public:
	NodeIndex(int size=20000);
	~NodeIndex();
	void addData(PairDist *pd);
	void convert();
	NodeNbrList *operator[](int idx) {
		return(index[idx]);
	}
	vector<DistData*>* getTmpIdx(int idx);
	int size() {
		return(status == CLUSTERING ? index.size() : indexTmp.size());
	}
};

class DistMat {
	vector<PairDist *>* homSet;
	double minCut, maxCut;
	double minDist, maxDist;
	int distscale;
	NodeIndex nodeIndex;
	BinQueue<PairDist*> *binQ;
	SimValue::Best simBest;
	static const double BIG_VALUE; /* = DBL_MAX; defined in DistMat.cpp */
	static const double SMALL_VALUE; /* = -DBL_MAX */
	static double UM_TOL_RATIO;
	void orderTriDist(PairDist *d1, PairDist *d2, PairDist *d3, PairDist*& od1, PairDist*& od2, PairDist*& od3);
	double checkTriangle(PairDist *d1, PairDist *d2, PairDist *d3);
	double checkUltraMetricity(PairDist *d1, PairDist *d2, PairDist *d3);
public:
	DistMat(vector<PairDist*>* d, SimValue::Best b=SimValue::MAX, int distscale=0);
	~DistMat();
	void setDistCutoff(double min, double max=BIG_VALUE);
	void add(PairDist *pd);
	void sort();
	bool definedDist(double dist);
	void createIndices();
	void createBinQueue();
	void correctDistance(SpecSetInstances *spSetInst, int corrMode=0);
	void set_UMtolerance(double tolerance) {UM_TOL_RATIO = tolerance;}
	NodeNbrList* findNeighbors(ClusterNode *node);
	int getBestData(PairDist*& bestDist);
	void printMat();
	size_t size();
};
#endif
