#ifndef __DOMAIN_H__
#define __DOMAIN_H__
#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <list>
#include <map>
#include <set>
#include "MemAlloc.hpp"

using namespace std;

typedef unsigned short seqpos_t;
typedef unsigned short domnum_t;

class GeneName {
public:
	static string getSpec(string name);
};

class SeqReg {
protected:
	seqpos_t from, to;
public:
	SeqReg() {};
	SeqReg(int _from, int _to);
	void setData(int _from, int _to);
	void copyData(SeqReg *reg);
	inline int getFrom() const { return from; }
	inline int getTo() const { return to; }
	int getLength() const { return to - from + 1; }
	bool overlapCheck(SeqReg *reg);
	bool overlapCheckStrict(SeqReg *reg);
	bool overlap(SeqReg *reg, int ovlen=1);
	int overlapLen(SeqReg *reg);
	void translate(int pos) {from += pos; to += pos; }
	void limitRegion(SeqReg *reg);
	void transform(SeqReg* reg1, SeqReg *reg2, SeqReg *newreg);
	void transform(SeqReg* reg1, SeqReg *reg2);
	int transformPos(int pos, SeqReg* reg1, SeqReg *reg2);
	friend ostream& operator<<(ostream&, const SeqReg&);
};

class Domain : public SeqReg {
	string name;
	Domain *base_dom;
	domnum_t domnum;
	int clustid;
	list<int> subids;
public:
	Domain() : subids() {};
	Domain(string& _name, int _from, int _to, int _domnum=0);
	string toString();
	inline string getName() const { return name; }
	string getOrigName();
	inline string getSpec() const { return GeneName::getSpec(name); }
	string getDomName() const;
	Domain *getOrigDomain(Domain *in=NULL) ;
	void setDomName(string& _name) {name=_name;}
//	string getName() const;
	inline int getDomNum() const { return domnum; }
	inline int getClustID() const { return clustid; }
	inline void setClustID(int clid) { clustid = clid; }
	inline void setDomNum(int _domnum) { domnum = _domnum; }
	inline void addSubClustID(int subid) { subids.push_back(subid); }
	inline list<int>::iterator beginSubClustID() { return subids.begin(); }
	inline list<int>::iterator endSubClustID() { return subids.end(); }
	inline void copySubClustIDs(Domain *dom) { subids = dom->subids; }
	inline int subids_size() { return subids.size(); }

	void setData(string& _name, int _from, int _to, int _domnum=0);
	void setData(Domain *_base_dom, int _from, int _to, int _domnum=0);
	void copyData(Domain *dom);
	void placeOn(Domain* dom);
	bool overlapAll(Domain *dom);
	bool overlap(Domain *dom, int ovlen=1);
	Domain * getBaseDom() { return base_dom; }
	friend ostream& operator<<(ostream&, const Domain&);
};
class DomainPool {
	static MemAlloc<Domain> objPool;
public:
	static Domain *create();
	static Domain *create(string& name, int from, int to, int domnum = 0);
	static Domain *create(Domain *base_dom,
			int from = 1, int to = 0, int domnum = 0);
	static Domain *duplicate(Domain *dom0);
	static void markCurrent();
	static void resetToMarkedPos();
};

class DomInfo {
	typedef vector<Domain*> GeneDomList;
	typedef map<string, int> GeneDomMap;
	typedef set<string> SpSet;
	GeneDomList domList;
	GeneDomMap geneDomMap;
	SpSet spSet;
public:
	DomInfo();
	void addDomain(Domain *dom);
	void makeIndex();
	list<Domain*>* getOvlpDomains(Domain *dom);
	void printDomains();
	void setSp(string sp);
	bool findSp(string sp);
};
#endif
