#ifndef _GENEDATA_H_
#define _GENEDATA_H_
#include <iostream>
#include <map>
#include <vector>
#include <string>

using namespace std;

class GeneData {
	string spec, name;
	int len, pos, dir;
	double maxscore;
	int maxclust;
public:
	GeneData(string& _spec, string& _name, int& _len, int& _pos, int& _dir);
	void setMaxClust(double _score, int _clust)
		{maxscore=_score; maxclust=_clust;}
	double getMaxScore() {return maxscore;}
	int getLength() {return len;}
	int getMaxClust() {return maxclust;}
	void print();
	friend ostream& operator<<(ostream&, const GeneData&);
	inline string getName() { return (spec + ":" + name); }
	string getSpec() {return spec;}
};

typedef map< string, int > GeneMap_t;

class GeneDataSet {
	vector<GeneData> geneSet;
	GeneMap_t geneMap;
	int newSpDataIdx;
public:
	GeneDataSet();
	GeneData &getGeneData(int idx) {return geneSet[idx];}
	GeneData* getGeneDataByName(string name);
	int getGeneDataSize() {return geneSet.size();}
	void addGeneData(GeneData& g) {geneSet.push_back(g);}
	void setNewSpDataIdx(int idx=0) {newSpDataIdx = ((idx==0) ? geneSet.size() : idx);}
	int getNewSpDataIdx() {return newSpDataIdx;}
	void printAllGenes();
	void makeIndex();
};

#endif
