#ifndef _HCLUSTER_H_
#define _HCLUSTER_H_
#include "DistMat.h"

struct Trinary {
	PairDist *e1, *e2;
	ClusterNode *n3;

	Trinary() { }
	Trinary(PairDist *_e1, PairDist *_e2, ClusterNode *_n3) :
		e1(_e1), e2(_e2), n3(_n3) {
	}
	void calcDist(PairDist *best, PairDist *newDist);
	friend ostream& operator<<(ostream& ost, Trinary& tri) {
		return(ost << tri.e1 << " " << tri.e2 <<endl);
	}
};

class Hcluster {
	DistMat *dmat;
	double cutoff;
	double phylocutratio;
	SpecSet newSPflag;
	bool spSet_flag;
	bool noCutoffCheck;
public:
	static double missDist, missScore;
	Hcluster(DistMat* _dmat, double _cutoff, double _missDist=0, double _phylocutratio=0, bool noCutoffCheck=true);
	void setMissDist(double _missDist) {
		missDist = _missDist;
	}
/*
	void setSpSet(set<string> *spSet);
*/
	void setSpSet(SpecSet *addedSpSet);
	void execute();
	void mergeClusters(PairDist *bestDist);
	void checkDeleted(ClusterNode *cnode);
//	list<ClusterNode*> *listRootNodes();
};
class Nlist {
	MemAlloc<Trinary> trinaryPool;
	list<Trinary*> nlist;
	ClusterNode *otherNode(PairDist *e, ClusterNode *n);
	Trinary *createTrinary(PairDist *e1, PairDist *e2, ClusterNode *n3);
public:
	Nlist(DistMat *dmat, PairDist *bestPair);
	list<Trinary*>::iterator begin() {
		return nlist.begin();
	}
	list<Trinary*>::iterator end() {
		return nlist.end();
	}
	Trinary* front() {
		return nlist.front();
	}
};
#endif
