#ifndef _HOMDATA_H_
#define _HOMDATA_H_
#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>
#include <ext/hash_map>
#include <map>
#include <list>
#include "Domain.h"
#include "MemAlloc.hpp"
#include "ClusterInfo.h"
#include "GeneData.h"
#include "SpecSetInstances.h"

class HomData {
	static enum {SCORE, PAM} distType;
public:
	Domain *dom1, *dom2;
	double pam, score;
//	static const int MEM_CUTOFF = 10000000;
	static const int MEM_CUTOFF = 100;
	HomData(string& _name1, string& _name2, int& _from1, int& _to1,
		int& _from2, int& _to2, double& _pam, double& _score);
	HomData(Domain* _dom1, Domain* _dom2, double _pam, double _score);
	void print(ostream& ost=cout);
	bool checkAddedSpecPair();
	friend ostream& operator<<(ostream&, const HomData&);
};
struct cmpHomDataByScore {
	bool operator()(HomData * const &h1, HomData * const &h2) const {
		return h1->score > h2->score;
	}
};

//typedef map< string, int > GeneMap_t;

typedef map< string, list<int>* > Gene2HomMap_t;
typedef list<HomData*> HomDataList;

class HomSetMap {
	map<string, HomData*> homSetMapData;
public:
	typedef map<string,HomData*>::iterator iterator;
	HomSetMap();
	void add(HomData *homData);
	iterator begin();
	iterator end();
/*
	pair<string,HomData*>::iterator rbegin() {
		return homSetMapData.rbegin();
	}
	void rend() {
		homSetMapData.rend();
	}
*/
};

class HomDataSet {
	void addGene2HomMap(string name, int idx);
	GeneDataSet geneSet;
	vector<HomData> homSet;
	set<string> addedSpSet;
	Gene2HomMap_t gene2HomMap;
public:
	HomDataSet();
	~HomDataSet();

	HomData& getHomData(int idx) {return homSet[idx];}
//	GeneData& getGeneData(int idx) {return geneSet[idx];}
	GeneData& getGeneData(int idx) {return geneSet.getGeneData(idx);}
	GeneData* getGeneDataByName(string name) {return geneSet.getGeneDataByName(name);}
	void makeGeneIndex() {geneSet.makeIndex();}
//	int getGeneDataSize() {return geneSet.size();}
	int getGeneDataSize() {return geneSet.getGeneDataSize();}

	void setNewSpDataIdx(int idx=0) {geneSet.setNewSpDataIdx(idx);}
	int getNewSpDataIdx() {return geneSet.getNewSpDataIdx();}

	HomDataList* getGeneHomologs(Domain *dom, HomDataList *homList=NULL, bool reset=true);
	HomDataList* getAllHomologData(HomDataList *homList=NULL, bool reset=true);

	void addGeneData(GeneData& g);
	void addHomData(HomData& h);
	void clearHomData();
	void clearGene2HomMap();
	int getDataSize() {return homSet.size();}
	void makeIndex();
	void printAllGenes();
	void printAllHom();
	set<string>* getAddedSpSet() { return &addedSpSet; }
	void insertAddedSpSet(string spec);
	bool checkAddedSpec(string spname) {
		return (addedSpSet.find(spname) != addedSpSet.end());
	}
	void clearHomDataList(HomDataList *homList);
};

// for using hash_map
/*
namespace __gnu_cxx {
  template<> struct hash< string > {
	size_t operator()( const string& x ) const {
		return hash< const char* >()( x.c_str() );
	}
  };
}
*/

class ReadHomData {
	ifstream ifs;
	istream *isp;
	vector<string> files;
	unsigned int filenum;
	DomInfo *domInfo;
	Options *opt;
	SpecSetInstances *specset;
	enum {GeneMode, HomMode} mode;
	bool newspFlag;
	string next_line;
	string curr_geneName;
public:
	ReadHomData();
	int openFiles(vector<string> files);
	int openFile(string file) { return openFile(file.c_str()); }
	int openFile(const char *file);
	int resetMode();
	bool endOfData();
	int getNextLine(char *buf);
	HomDataSet *readAllData(HomDataSet *homSet = NULL);
	HomDataSet *readEachData(HomDataSet *homSet = NULL);
	HomDataSet *readData(HomDataSet *homSet , int sequential);
	void setInfoAll(DomInfo *_dinfo, Options *_opt,
			SpecSetInstances *_sinst) {
		domInfo = _dinfo; opt = _opt; specset = _sinst; }
	void setDomInfo(DomInfo *dinfo) { domInfo = dinfo; }
	void setOpt(Options *_opt) { opt = _opt; }
	void addAllOvlpDomains(HomDataSet *homDataSet,
		Domain *dom1, Domain *dom2, double pam, double score);
	string getCurrGeneName() { return curr_geneName; }
};
#endif /* _HOMDATA_H_ */
