#ifndef _MEMALLOC_H_
#define _MEMALLOC_H_
#include <list>
#include <vector>

using namespace std;

template<typename T>
class MemAlloc {
	size_t blksiz, recno, alcsiz, markedPos, maxRetain;
	list<vector<T>*> regList;
	typename list<vector<T>*>::iterator currListP;
	list<T *>* free;
public:
	typedef T* pointer;
	MemAlloc(size_t _blksiz=100, bool withFree=true, size_t _maxRetain = 10000){
		blksiz = _blksiz;
		recno = _blksiz;
		maxRetain = _maxRetain;
		alcsiz = 0;
		free = NULL;
		if (withFree) {
			free = new list<T *>();
		}
		currListP = regList.end();
	}
	~MemAlloc() {
		deleteAll();
	}
	T* create(const T& val) {
		T *ret = allocate();
		construct(ret, val);
		return ret;
	}
	T* allocate(size_t size=1, void* hint= 0) {
		T *retptr;
		if (size == 1 && free && ! free->empty() ) {
			// reuse a space from the freelist
//cout << "*******usefree>>"<<free << endl;
			retptr = free->front();
			free->pop_front();
			if (retptr) {
				return static_cast<T*>(retptr);
			}
		}
		if (recno + size > blksiz) {
			vector<T>* newReg;
			if (currListP == regList.end() || ++currListP == regList.end()) {
			 	newReg = new vector<T>(blksiz);
/* for DEBUG
cout << "new:" << typeid(T).name() << " " << newReg << " " << alcsiz+blksiz << endl;
*/
				regList.push_back( newReg );
				currListP = regList.end(); currListP--;
			} else {
				newReg = *currListP;
			}
			retptr = &( (*newReg)[0] );
			recno = 1;	      // next point
		} else {
/*
			retptr = &( (**(regList.rbegin()))[recno] );
*/
			retptr = &( (**currListP)[recno] );
			recno++;		//next point
		}
		alcsiz++;

	/* for DEBUG
		if (alcsiz % 1000 == 0) {
			cout<< typeid(retptr).name() << " " << alcsiz <<" " << sizeof(T)<< endl;
		}
	*/


//cout << "*******alloc>>" <<retptr<< ",reg= " << *(regList.rbegin()) << ",recno=" << recno << endl;
		return retptr;
	}
	void construct(pointer p, const T& val) {
		new(p) T(val);
	}
	T* getObj(int idx) {
		int blkno = idx / blksiz;
		int recno = idx % blksiz;
		if (blkno > regList.size()) {
			return NULL;
		}
		typename list<vector<T>*>::iterator p = regList.begin();
		for (int i = 0; i < blkno; i++) {
			++p;
		}
		return &( (**p)[recno] );
	}
	void deleteAll() {
		typename list<vector<T>*>::iterator p;

	/* for DEBUG
		cout << "*******delete data!!!>>"<< typeid(T).name() << " " << alcsiz << " " << free << " count:"<< regList.size() << endl;
	*/

//int i = 0;
		for (p = regList.begin(); p != regList.end(); p++) {
			vector<T>* vp = *p;
			delete vp;
//++i;
		}
//cout << "delete OK:" << i << " " << i * blksiz * sizeof(T) << endl;
		regList.erase(regList.begin(), regList.end());
		// clear free list
		free->erase(free->begin(), free->end());
		recno = blksiz;
		alcsiz = markedPos = 0;
		currListP = regList.end();
	}
	void freeAll() {
	}
	void freeData(T* ptr) {
//cout << "*******free_data!!!>>"<<free << endl;
		free->push_back(ptr);
	}
	void markCurrent() {
		markedPos = alcsiz;
	}
	int allocSize() {
		return alcsiz;
	}
	void resetToMarkedPos() {
		typename list<vector<T>*>::iterator p;
		size_t pos = 0;
		for (p = regList.begin(); p != regList.end(); p++) {
			if (pos + blksiz > markedPos) {
				currListP = p;
				break;
			}
			pos += blksiz;
		}
		if (p == currListP && alcsiz > maxRetain) {
			vector<T>* reg;
//int i = 0;
			while ((reg = regList.back()) != (*p) && alcsiz > maxRetain) {
//cerr << "DELETE:" << i++ << " " << alcsiz << " " << maxRetain << " " << markedPos << "\n";
				delete reg;
				regList.pop_back();
				alcsiz-=blksiz;
			}
		}
		recno = (markedPos % blksiz);
		alcsiz = markedPos;
//cout << alcsiz << " " << recno << endl;
	}
	void clearMarkedPos() {
		markedPos = 0;
	}
};
#endif
