#ifndef _SPECSETINST_H_
#define _SPECSETINST_H_
#include "SpecSet.h"

class SpecSetInstances {
	static SpecSetInstances *instance;
	SpecSetInstances() { }
public:
	static SpecSetInstances *getInstance() {
		if (instance == NULL) {
			instance = new SpecSetInstances();
		}
		return instance;
	}
	void setSpecialSpecies(char* metaPref, char* metaList, char* taxQueryList, char* partialList, int _spnum);
	void addUndefinedSpecies(int beginIdx=0);
	void addIgnoreSpecies(SpecSet* spSet);
	void setMetaSpecies(char *specList, char *pref);
	void setTaxQuerySpecies(char *specList);
	void setPartialSpecies(char *specList);

/*
	void setUnknownSpecies(char *specList);
*/

	bool taxQueryMode();
	bool unknownOnlyCluster(const SpecSet& spSet);
	bool knownOnlyCluster(const SpecSet& spSet);
	bool taxQueryCluster(const SpecSet& spSet);
	bool taxKnownCluster(const SpecSet& spSet);
	bool partialOnlyCluster(const SpecSet& spSet);
	bool ignoreOnlyCluster(const SpecSet& spSet);
	bool checkPartial(const string& spname);

	SpecSet meta_SpecSet;
	SpecSet taxQuery_SpecSet;
	SpecSet unknown_SpecSet;
	SpecSet ignore_SpecSet;
	SpecSet partial_SpecSet;
	int spnum_in_sptree;
};
#endif
